% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_spec.R
\name{row_spec}
\alias{row_spec}
\title{Specify the look of the selected row}
\usage{
row_spec(kable_input, row, bold = FALSE, italic = FALSE)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{row}{A numeric value indicating which row to be selected. You don't
need to count in header rows or group labeling rows.}

\item{bold}{A T/F value to control whether the text of the selected row
need to be bolded.}

\item{italic}{A T/F value to control whether the text of the selected row
need to be emphasized.}
}
\description{
This function allows users to select a row and then specify
its look. Right now it supports the following two properties: bold text and
italic text.
}
\examples{
x <- knitr::kable(head(mtcars), "html")
row_spec(x, 1, bold = TRUE, italic = TRUE)

}
