% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pathway.r
\docType{methods}
\name{pathway_info}
\alias{pathway_info}
\alias{pathway_info,character-method}
\alias{show,pathway_info-method}
\alias{show,pathway_info,ANY-method}
\alias{summary,pathway_info-method}
\alias{summary,pathway_info,ANY-method}
\title{An S4 class for an object assigning genes to pathways}
\usage{
pathway_info(x)

\S4method{pathway_info}{character}(x)

\S4method{show}{pathway_info}(object)

\S4method{summary}{pathway_info}(object)
}
\arguments{
\item{x}{A \code{character} identifying the pathway for which gene infomation 
should be extracted. Here KEGG IDs (format: 'hsa00100') are used.}

\item{object}{An object of class \code{\link{pathway_info}}.}
}
\value{
A \code{data.frame} including as many rows as genes appear in the 
\code{\link{pathway}}. for each gene its name, the start and end point and the chromosome 
it lies on are given.

\code{show} Basic information on \code{\link{pathway_info}} object.

\code{summary} Summarized information on \code{\link{pathway_info}} object.
}
\description{
An S4 class for an object assigning genes to pathways

This function lists all genes formig a particular \code{\link{pathway}}. Start and end  
positions of these genes are extracted from the Ensemble database. The 
database is accessed via the R-package \pkg{biomaRt}.

\code{show} Shows basic information on \code{\link{pathway_info}} object

\code{summary} Summarizes information on \code{\link{pathway_info}} object
}
\section{Slots}{

\describe{
\item{\code{info}}{A \code{data.frame} including information on genes contained in 
pathways with columns 'pathway', 'gene_start', 'gene_end', 'chr' and 'gene'.}
}}

\examples{
pathway_info("hsa04022") 

# show method
data(hsa04022_info)
hsa04022_info
# summary method
data(hsa04022_info)
summary(hsa04022_info)
}
\author{
Stefanie Friedrichs
}
