% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kantorovich.R
\name{ejoinings}
\alias{ejoinings}
\title{Extreme joinings}
\usage{
ejoinings(mu, nu, zeros = FALSE)
}
\arguments{
\item{mu}{row margins}

\item{nu}{column margins}

\item{zeros}{logical; in case when \code{mu} and \code{nu} have differente lengths, set \code{FALSE} to remove lines or columns full of zeros}
}
\value{
a list with the extreme joinings (matrices)
}
\description{
Return extreme joinings between \code{mu} and \code{nu}
}
\examples{
mu <- nu <- c(0.5, 0.5)
ejoinings(mu, nu)
# use exact arithmetic
library(gmp)
mu <- nu <- as.bigq(c(0.5,0.5))
ejoinings(mu, nu)
# different lengths example
mu <- setNames(as.bigq(c(1,2,4), 7), c("a", "b", "c"))
nu <- setNames(as.bigq(c(3,1), 4), c("b", "c"))
ejoinings(mu, nu)

}

