% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getChrOrder.R
\name{getChrOrder}
\alias{getChrOrder}
\title{Get chromosome order from a string of chromosome/contig names}
\usage{
getChrOrder(chr.vector)
}
\arguments{
\item{chr.vector}{Character vector of chromosome or contig names.}
}
\value{
A numerical vector of the input vectors indices in chromosome order.
}
\description{
\code{getChrOrder()} takes a string of chromosome or contig names and returns the indices of the string in typical chromosome order, i.e. 1 through 22, X, Y.
Contig names that do not match 1:22, X, or Y are sorted numerically and alphabetically (with numbers coming first), and added to the end of the order.
The output string can then be used to sort the input string into typical chromosome order.
}
\examples{
chr.order <- getChrOrder(c(1, "virus", 5, "X", 22, "plasmid", "Y"))
ordered.vector <- c(1, "virus", 5, "X", 22, "plasmid", "Y")[chr.order]
}
\concept{build experiment}
