% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussianMixtureCalls.R
\name{getGMMBoundaries}
\alias{getGMMBoundaries}
\title{Calculate decision boundaries between components of copy number GMMs}
\usage{
getGMMBoundaries(TapestriExperiment, chromosome.scope = "chr")
}
\arguments{
\item{TapestriExperiment}{\code{TapestriExperiment} object.}

\item{chromosome.scope}{"chr" or "arm", for using models for either whole chromosomes or chromosome arms. Default "chr".}
}
\value{
tibble containing boundary values of GMMs for each \code{feature.id}.
}
\description{
Calculate decision boundaries between components of copy number GMMs
}
\examples{
\donttest{
tap.object <- newTapestriExperimentExample() # example TapestriExperiment object
tap.object <- calcNormCounts(tap.object)
control.copy.number <- generateControlCopyNumberTemplate(tap.object,
  copy.number = 2,
  sample.feature.label = "cellline1"
)
tap.object <- calcCopyNumber(tap.object,
  control.copy.number,
  sample.feature = "test.cluster"
)
tap.object <- calcSmoothCopyNumber(tap.object)
tap.object <- calcGMMCopyNumber(tap.object,
  cell.barcodes = colnames(tap.object),
  control.copy.number = control.copy.number,
  model.components = 1:5
)

boundaries <- getGMMBoundaries(tap.object,
  chromosome.scope = "chr"
)
}
}
\concept{copy number}
