% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdtools.R
\name{kd_sort}
\alias{kd_sort}
\alias{kd_is_sorted}
\title{Sort multidimensional data}
\usage{
kd_sort(x, ...)

kd_is_sorted(x)
}
\arguments{
\item{x}{a matrix or arrayvec object}

\item{...}{other arguments}
}
\description{
Sort multidimensional data
}
\details{
The algorithm used is a divide-and-conquer quicksort variant that
  recursively partions an range of tuples using the median of each successive
  dimension. Ties are resolved by cycling over successive dimensions. The
  result is an ordering of tuples matching their order if they were inserted
  into a kd-tree.
}
\note{
The matrix version will be slower because of data structure
  conversions.
}
\examples{
x = kd_sort(matrix(runif(200), 100))
kd_is_sorted(x)
plot(x, type = "o", pch = 19, col = "steelblue", asp = 1)

}
\seealso{
\code{\link{arrayvec}}
}
