% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_dot}
\alias{layer_dot}
\title{Layer that computes a dot product between samples in two tensors.}
\usage{
layer_dot(inputs, axes, normalize = FALSE, batch_size = NULL,
  dtype = NULL, name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{inputs}{A list of input tensors (at least 2).}

\item{axes}{Integer or list of integers, axis or axes along which to take the dot product.}

\item{normalize}{Whether to L2-normalize samples along the dot product axis before taking the dot product. If set to TRUE, then the output of the dot product is the cosine proximity between the two samples. **kwargs: Standard layer keyword arguments.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\value{
A tensor, the dot product of the samples from the inputs.
}
\description{
Layer that computes a dot product between samples in two tensors.
}
\seealso{
Other merge layers: \code{\link{layer_add}},
  \code{\link{layer_average}},
  \code{\link{layer_concatenate}},
  \code{\link{layer_maximum}},
  \code{\link{layer_multiply}},
  \code{\link{layer_subtract}}
}
