% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_lambda}
\alias{callback_lambda}
\title{Create a custom callback}
\usage{
callback_lambda(on_epoch_begin = NULL, on_epoch_end = NULL,
  on_batch_begin = NULL, on_batch_end = NULL, on_train_begin = NULL,
  on_train_end = NULL)
}
\arguments{
\item{on_epoch_begin}{called at the beginning of every epoch.}

\item{on_epoch_end}{called at the end of every epoch.}

\item{on_batch_begin}{called at the beginning of every batch.}

\item{on_batch_end}{called at the end of every batch.}

\item{on_train_begin}{called at the beginning of model training.}

\item{on_train_end}{called at the end of model training.}
}
\description{
This callback is constructed with anonymous functions that will be called at
the appropriate time. Note that the callbacks expects positional arguments,
as:
\itemize{
\item \code{on_epoch_begin} and \code{on_epoch_end} expect two positional arguments: \code{epoch}, \code{logs}
\item \code{on_batch_begin} and \code{on_batch_end} expect two positional arguments: \code{batch}, \code{logs}
\item \code{on_train_begin} and \code{on_train_end} expect one positional argument: \code{logs}
}
}
\seealso{
Other callbacks: \code{\link{callback_csv_logger}},
  \code{\link{callback_early_stopping}},
  \code{\link{callback_learning_rate_scheduler}},
  \code{\link{callback_model_checkpoint}},
  \code{\link{callback_progbar_logger}},
  \code{\link{callback_reduce_lr_on_plateau}},
  \code{\link{callback_remote_monitor}},
  \code{\link{callback_tensorboard}},
  \code{\link{callback_terminate_on_naan}}
}
