% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{zip_lists}
\alias{zip_lists}
\title{zip lists}
\usage{
zip_lists(...)
}
\arguments{
\item{...}{R lists or atomic vectors, optionally named.}
}
\value{
A inverted list
}
\description{
This is conceptually similar to \code{zip()} in Python, or R functions
\code{purrr::transpose()} and \code{data.table::transpose()} (albeit, accepting
elements in \code{...} instead of a single list), with one crucial difference: if
the provided objects are named, then matching is done by names, not
positions.
}
\details{
All arguments supplied must be of the same length. If positional matching is
required, then all arguments provided must be unnamed. If matching by names,
then all arguments must have the same set of names, but they can be in
different orders.
}
\examples{
gradients <- list("grad_for_wt_1", "grad_for_wt_2", "grad_for_wt_3")
weights <- list("weight_1", "weight_2", "weight_3")
str(zip_lists(gradients, weights))
str(zip_lists(gradient = gradients, weight = weights))

names(gradients) <- names(weights) <- paste0("layer_", 1:3)
str(zip_lists(gradients, weights[c(3, 1, 2)]))

names(gradients) <- paste0("gradient_", 1:3)
try(zip_lists(gradients, weights)) # error, names don't match
# call unname directly for positional matching
str(zip_lists(unname(gradients), unname(weights)))
}
