% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_multiply}
\alias{layer_multiply}
\title{Layer that multiplies (element-wise) a list of inputs.}
\usage{
layer_multiply(inputs, ...)
}
\arguments{
\item{inputs}{A list of input tensors (at least 2). Can be missing.}

\item{...}{Standard layer arguments (must be named).}
}
\value{
A tensor, the element-wise product of the inputs. If \code{inputs} is
missing, a keras layer instance is returned.
}
\description{
It takes as input a list of tensors, all of the same shape, and returns a
single tensor (also of the same shape).
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/multiply}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Multiply}
\item \url{https://keras.io/api/layers/merging_layers/multiply}
}

Other merge layers: 
\code{\link{layer_average}()},
\code{\link{layer_concatenate}()},
\code{\link{layer_dot}()},
\code{\link{layer_maximum}()},
\code{\link{layer_minimum}()},
\code{\link{layer_subtract}()}
}
\concept{merge layers}
