% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_remote_monitor}
\alias{callback_remote_monitor}
\title{Callback used to stream events to a server.}
\usage{
callback_remote_monitor(
  root = "https://localhost:9000",
  path = "/publish/epoch/end/",
  field = "data",
  headers = NULL,
  send_as_json = FALSE
)
}
\arguments{
\item{root}{root url of the target server.}

\item{path}{path relative to root to which the events will be sent.}

\item{field}{JSON field under which the data will be stored.}

\item{headers}{Optional named list of custom HTTP headers. Defaults to:
\verb{list(Accept = "application/json", }Content-Type\verb{ = "application/json")}}

\item{send_as_json}{Whether the request should be sent as application/json.}
}
\description{
Callback used to stream events to a server.
}
\details{
Events are sent to \code{root + '/publish/epoch/end/'} by default. Calls
are HTTP POST, with a \code{data} argument which is a JSON-encoded dictionary
of event data. If send_as_json is set to True, the content type of the
request will be application/json. Otherwise the serialized JSON will be
send within a form
}
\seealso{
Other callbacks: 
\code{\link{callback_csv_logger}()},
\code{\link{callback_early_stopping}()},
\code{\link{callback_lambda}()},
\code{\link{callback_learning_rate_scheduler}()},
\code{\link{callback_model_checkpoint}()},
\code{\link{callback_progbar_logger}()},
\code{\link{callback_reduce_lr_on_plateau}()},
\code{\link{callback_tensorboard}()},
\code{\link{callback_terminate_on_naan}()}
}
\concept{callbacks}
