% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-methods.R
\name{get_config}
\alias{get_config}
\alias{from_config}
\title{Layer/Model configuration}
\usage{
get_config(object)

from_config(config)
}
\arguments{
\item{object}{Layer or model object}

\item{config}{Object with layer or model configuration}
}
\value{
\code{get_config()} returns an object with the configuration,
\code{from_config()} returns a re-instantiation of the object.
}
\description{
A layer config is an object returned from \code{get_config()} that contains the
configuration of a layer or model. The same layer or model can be
reinstantiated later (without its trained weights) from this configuration
using \code{from_config()}. The config does not include connectivity information,
nor the class name (those are handled externally).
}
\note{
Objects returned from \code{get_config()} are not serializable. Therefore,
if you want to save and restore a model across sessions, you can use the
\code{model_to_json()} function (for model configuration only, not weights) or
the \code{save_model_tf()} function to save the model configuration and weights
to the filesystem.
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_layer}()},
\code{\link{keras_model_sequential}()},
\code{\link{keras_model}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{predict_proba}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}

Other layer methods: 
\code{\link{count_params}()},
\code{\link{get_input_at}()},
\code{\link{get_weights}()},
\code{\link{reset_states}()}
}
\concept{layer methods}
\concept{model functions}
