% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-utils.R
\name{pack_x_y_sample_weight}
\alias{pack_x_y_sample_weight}
\title{Packs user-provided data into a list.}
\usage{
pack_x_y_sample_weight(x, y = NULL, sample_weight = NULL)
}
\arguments{
\item{x}{Features to pass to \code{Model}.}

\item{y}{Ground-truth targets to pass to \code{Model}.}

\item{sample_weight}{Sample weight for each element.}
}
\value{
List in the format used in \code{fit()}.
}
\description{
This is a convenience utility for packing data into the list formats
that \code{fit()} uses.
}
\section{Usage}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- op_ones(c(10, 1))
data <- pack_x_y_sample_weight(x)


y <- op_ones(c(10, 1))
data <- pack_x_y_sample_weight(x, y)
}\if{html}{\out{</div>}}
}

\seealso{
Other data utils: \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{unpack_x_y_sample_weight}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{data utils}
\concept{utils}
\keyword{internal}
