% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image-utils.R
\name{image_load}
\alias{image_load}
\title{Loads an image into PIL format.}
\usage{
image_load(
  path,
  color_mode = "rgb",
  target_size = NULL,
  interpolation = "nearest",
  keep_aspect_ratio = FALSE
)
}
\arguments{
\item{path}{Path to image file.}

\item{color_mode}{One of \code{"grayscale"}, \code{"rgb"}, \code{"rgba"}. Default: \code{"rgb"}.
The desired image format.}

\item{target_size}{Either \code{NULL} (default to original size) or tuple of ints
\verb{(img_height, img_width)}.}

\item{interpolation}{Interpolation method used to resample the image if the
target size is different from that of the loaded image. Supported
methods are \code{"nearest"}, \code{"bilinear"}, and \code{"bicubic"}.
If PIL version 1.1.3 or newer is installed, \code{"lanczos"}
is also supported. If PIL version 3.4.0 or newer is installed,
\code{"box"} and \code{"hamming"} are also
supported. By default, \code{"nearest"} is used.}

\item{keep_aspect_ratio}{Boolean, whether to resize images to a target
size without aspect ratio distortion. The image is cropped in
the center with target aspect ratio before resizing.}
}
\value{
A PIL Image instance.
}
\description{
Loads an image into PIL format.
}
\section{Example}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{image_path <- get_file(origin = "https://www.r-project.org/logo/Rlogo.png")
(image <- image_load(image_path))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## <PIL.Image.Image image mode=RGB size=724x561 at 0x0>

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{input_arr <- image_to_array(image)
str(input_arr)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{##  num [1:561, 1:724, 1:3] 0 0 0 0 0 0 0 0 0 0 ...

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{input_arr \%<>\% array_reshape(dim = c(1, dim(input_arr))) # Convert single image to a batch.
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{model |> predict(input_arr)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/data_loading/image#loadimg-function}
}

Other image utils: \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{op_image_affine_transform}()} \cr
\code{\link{op_image_crop}()} \cr
\code{\link{op_image_extract_patches}()} \cr
\code{\link{op_image_hsv_to_rgb}()} \cr
\code{\link{op_image_map_coordinates}()} \cr
\code{\link{op_image_pad}()} \cr
\code{\link{op_image_resize}()} \cr
\code{\link{op_image_rgb_to_grayscale}()} \cr
\code{\link{op_image_rgb_to_hsv}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_dataset_from_directory}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr
}
\concept{image utils}
\concept{utils}
