% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{keras_compile}
\alias{keras_compile}
\title{Compile a keras model}
\usage{
keras_compile(model, optimizer, loss, metrics = NULL,
  sample_weight_mode = NULL)
}
\arguments{
\item{model}{a keras model object, for example created with \code{\link[=Sequential]{Sequential()}}}

\item{optimizer}{name of optimizer) or optimizer object. See
\link{Optimizers}.}

\item{loss}{name of a loss function. See Details for
possible choices.}

\item{metrics}{vector of metric names to be evaluated by the
model during training and testing. See Details
for possible options. See \code{\link[=EarlyStopping]{EarlyStopping()}} for using these in callbacks.}

\item{sample_weight_mode}{if you need to do timestep-wise sample
weighting (2D weights), set this to \code{temporal}.
\code{None} defaults to sample-wise weights (1D).}
}
\description{
Models must be compiled before being fit or used for prediction.
This function changes to input model object itself, and does not produce
a return value.
}
\section{Loss functions}{

Possible losses are:
\itemize{
\item \code{mean_squared_error}
\item \code{mean_absolute_error}
\item \code{mean_absolute_percentage_error}
\item \code{mean_squared_logarithmic_error}
\item \code{squared_hinge}
\item \code{hinge}
\item \code{categorical_crossentropy}
\item \code{sparse_categorical_crossentropy}
\item \code{binary_crossentropy}
\item \code{kullback_leibler_divergence}
\item \code{poisson}
\item \code{cosine_proximity}.
}
}

\section{Metrics}{

Possible metrics are:
\itemize{
\item \code{binary_accuracy}
\item \code{categorical_accuracy}
\item \code{sparse_categorical_accuracy}
\item \code{top_k_categorical_accuracy}
}
}

\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(  Dropout(rate = 0.5))
  mod$add(Activation("relu"))
  mod$add(Dense(units = 3))
  mod$add(ActivityRegularization(l1 = 1))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())

  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
  # You can also add layers directly as arguments to Sequential()

  mod <- Sequential(
    Dense(units = 50, input_shape = ncol(X_train)),
    Dropout(rate = 0.5),
    Activation("relu"),
    Dense(units = 3),
    ActivityRegularization(l1 = 1),
    Activation("softmax")
  )
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5,
            verbose = 0, validation_split = 0.2)
  
}

}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other model functions: \code{\link{LoadSave}},
  \code{\link{Predict}}, \code{\link{Sequential}},
  \code{\link{keras_fit}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
