library(kerasR)

context("Testing preprocessing")

check_keras_available <- function() {
  if (!keras_available(silent = TRUE)) {
    skip("Keras is not available on this system.")
  }
}

test_that("preprocessing", {
  skip_on_cran()
  check_keras_available()

  pad_sequences(list(1:10, 1:100, 1:5), maxlen = 200)
  Tokenizer(num_words = 10)
  one_hot("hello", n = 10)
  text_to_word_sequence("hello")
  expand_dims(array(1))
  TimeDistributed(Dense(units = 3))

  BatchNormalization(input_shape = c(1,2))
  GaussianDropout(input_shape = c(1,2))
  GaussianNoise(input_shape = c(1,2))
  #LocallyConnected1D(input_shape = c(1,2), filters = 1, kernel_size = c(1))
  LocallyConnected2D(input_shape = c(1,2), filters = 1, kernel_size = c(1,1))
  Embedding(input_dim = c(1,2), output_dim = c(2,2), input_shape = c(1,1))
  Masking(1, input_shape = c(1,2))
  ActivityRegularization(input_shape = c(1,2))
  Permute(dims = c(1,2), input_shape = c(1,2))
  Reshape(c(1,2), input_shape = c(3))
  Flatten(input_shape = c(1))
  Dropout(input_shape = c(1), rate = 1)
  Activation("relu", input_shape = c(1,2))
  UpSampling3D(input_shape = c(1,2))
  UpSampling2D(input_shape = c(1,2))
  UpSampling1D(input_shape = c(1,2))
  Conv3D(filters = 1, kernel_size = c(1,1,1), input_shape = c(1,2))
  Conv2D(filters = 1, kernel_size = c(1,1), input_shape = c(1,2))
  Conv2DTranspose(filters = 1, kernel_size = c(1,1))
  SeparableConv2D(filters = 1, kernel_size = c(1,1))
  #Conv1D(filters = 1, kernel_size = c(1), input_shape = c(1,2))
  ThresholdedReLU(input_shape = c(1,2))
  ELU(input_shape = c(1,2))
  PReLU(input_shape = c(1,2))
  LeakyReLU(input_shape = c(1,2))
  ThresholdedReLU(input_shape = c(1,2))

  BatchNormalization()
  GaussianDropout()
  GaussianNoise()
  #LocallyConnected1D(filters = 1, kernel_size = c(1))
  LocallyConnected2D(filters = 1, kernel_size = c(1,1))
  Embedding(input_dim = c(1,2), output_dim = c(2,2))
  Masking(1)
  ActivityRegularization()
  Permute(dims = c(1,2))
  Reshape(c(1,2))
  Activation("relu")
  UpSampling3D()
  UpSampling2D()
  UpSampling1D()
  Conv3D(filters = 1, kernel_size = c(1,1,1))
  Conv2D(filters = 1, kernel_size = c(1,1))
  Conv2DTranspose(filters = 1, kernel_size = c(1,1))
  SeparableConv2D(filters = 1, kernel_size = c(1,1))
  #Conv1D(filters = 1, kernel_size = c(1))

})
