% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q1Diag.R
\name{q1Diag}
\alias{q1Diag}
\title{
  Qualitative Correlation or Covariance Kernel with one Input and
  Diagonal Structure
}
\usage{

q1Diag(factor, input = "x", cov = c("corr", "homo", "hete"), intAsChar = TRUE)

}
\arguments{
  
  \item{factor}{

    A factor with the wanted levels for the covariance
    kernel object.

  }
  \item{input}{

    Name of (qualitative) input for the kernel.

  }
  \item{cov}{

    Character telling if the result is a correlation kernel, an
    homoscedastic covariance kernel or an heteroscedastic covariance
    kernel with an arbitrary variance vector.
    
  }
  \item{intAsChar}{
    
    Logical. If \code{TRUE} (default), an integer-valued input will be
    coerced into a character. Otherwise, it will be coerced into a factor.
    
  }
}
\value{

  An object with class \code{"covQual"} with \code{d = 1} qualitative
  input.

}
\description{
  
  Qualitative correlation or covariance kernel with one input and diagonal
  structure.
  
}
\note{
  
  The correlation version obtained with \code{cov = "corr"} has no
  parameters.

}
\examples{
School <- factor(1L:3L, labels = c("Bad", "Mean" , "Good"))

## correlation: no parameter!
myCor <- q1Diag(School, input = "School")

## covariance 
myCov <- q1Diag(School, input = "School", cov = "hete")
coef(myCov) <- c(1.1, 2.2, 3.3)

}
\seealso{
  
  \code{\link{q1Symm}}, \code{\link{q1CompSymm}} are other covariance
  structures for one qualitative input.
  
}
