\name{mbo1d}
\alias{mbo1d}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Efficient global optimization in combination with one dimensional search
}
\description{
Implements the efficient global optimization algorithm based on Kriging. New design points are generated by the expected improvement criterion. It is optimized by one dimensional search algorithm and evaluates the function with a given number of steps.
}
\usage{
mbo1d(model, fun, nsteps, lower, upper, parinit, isoInput, 
maxRuns=3, repetitions=5, tol_input=.Machine$double.eps^0.25, addInfo=TRUE, 
nCores=1, envir=parent.frame())
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{model}{
Fitted Kriging model of the experimental design and evaluation measures. See \code{\link[DiceKriging]{km}}
}
\item{fun}{
Loss function to be minimized.
}
\item{nsteps}{
Number of points the efficient global optimizer should compute.
}
\item{lower}{
Vector of lower bounds of the tuning parameters. First element is the lower bound of the first tuning parameter, second element the lower bound of the next tuning parameter etc.
}
\item{upper}{
Vector of upper bounds of the tuning parameters. First element is the upper bound of the first tuning parameter, second element the upper bound of the next tuning parameter etc.
}
\item{parinit}{
Starting value of the one dimensional optimization algorithm. See \code{\link{optimize1dMulti}}.
}
\item{isoInput}{
Force the covariance structure of the km to have only one range parameter. For details see \code{\link[DiceKriging]{km}}.
}
\item{maxRuns}{
Maximum number of iterations of the one dimensional algorithm.
}
\item{repetitions}{
Maximum number of random starting values of the one dimensional algorithm.
}
\item{tol_input}{
Accuracy threshold of the one dimensional optimization algorithm. See \code{\link{optimize1dMulti}}.
}
\item{addInfo}{
Should additional information be displayed during optimization? (logical value). Default is FALSE.
}
\item{nCores}{
Specifies how many cores are used in tuning (integer scalar). Default=1 is serial processing. 
}
\item{envir}{
Internal variable to store environments. Default is to look up the one higher level environment. Modification is unnecessary.
}
}
\details{
In each step iteration the negative expected improvement criterion is minimized with the one dimensional algorithm. Then the loss function is evaluated at the proposed design point. The Kriging model is updated with the new point and refitted with nugget effect to ensure convergence. The starting value for the next step iteration is set to the parameter values with lowest function value.
}

\value{
Retains the parameter values with the lowest function value. The function value of this configuration is available as attribute.
}

\references{
Olivier Roustant and David Ginsbourger and Yves Deville, (2012), 
\emph{DiceKriging, DiceOptim: Two R Packages for the Analysis of 
Computer Experiments by Kriging-Based Metamodeling and Optimization},
Journal of Statistical Software, Volume 51, Issue 1

Donald R. Jones and Matthias Schonlau and William J. Welch, (1998), 
\emph{Efficient Global Optimization of Expensive Black-Box Functions},
Journal of Global Optimization 13: pages 455-492
}

\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}

\note{
Function is supplied for model customization and intended for the experienced user. The more user friendly function \code{\link{tuneMboKDSN}} uses this code as intermediate step.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{optimize1dMulti}}, \code{\link[DiceKriging]{km}}, \code{\link[DiceOptim]{EI}}, \code{\link{tuneMboKDSN}}, \code{\link{mboAll}}
}

%\examples{
%}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models & regression }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line