% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{read_keywords}
\alias{read_keywords}
\title{Convert a quanteda dictionary to keywords}
\usage{
read_keywords(file = NULL, docs = NULL, dictionary = NULL, split = TRUE, ...)
}
\arguments{
\item{file}{file identifier for a foreign dictionary, e.g. path to a dictionary in YAML or LIWC format}

\item{docs}{texts read via \code{\link[=keyATM_read]{keyATM_read()}}}

\item{dictionary}{a quanteda dictionary object, ignore if file is not NULL}

\item{split}{boolean, if multi-word terms be seperated, e.g. "air force" splits into "air" and "force".}

\item{...}{additional parameters for \code{\link[quanteda:dictionary]{quanteda::dictionary()}}}
}
\value{
a named list which can be used as keywords for e.g. \code{\link[=keyATM]{keyATM()}}
}
\description{
This function converts or reads a dictionary object from quanteda to a named list. "Glob"-style wildcard expressions (e.g. politic*) are resolved based on the available terms in your texts.
}
\examples{
\dontrun{
  library(keyATM)
  library(quanteda)
  ## using the moral foundation dictionary example from quanteda
  dictfile <- tempfile()
  download.file("http://bit.ly/37cV95h", dictfile)
  data(keyATM_data_bills)
  bills_dfm <- keyATM_data_bills$doc_dfm
  keyATM_docs <- keyATM_read(bills_dfm)
  read_keywords(file = dictfile, docs = keyATM_docs, format = "LIWC")
}
}
\seealso{
\code{\link{dictionary}}
}
