% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_datasets_by_level.R
\name{get_data_sets_by_level}
\alias{get_data_sets_by_level}
\title{Retrieves Data Set Reporting Rate Metrics}
\usage{
get_data_sets_by_level(
  dataset_ids,
  start_date,
  end_date = NULL,
  level = 1,
  org_ids = NULL,
  ...,
  call = caller_env()
)
}
\arguments{
\item{dataset_ids}{Required vector of data sets IDs for which to retrieve data. Required.}

\item{start_date}{Optional start date to retrieve data. It is required and in the format \code{YYYY-MM-dd}.}

\item{end_date}{Optional ending date for data retrieval (default is the current date).}

\item{level}{Required desired organisation level of data (default: level 1) .}

\item{org_ids}{Optional list of organization units IDs to be filtered.}

\item{...}{Other options that can be passed onto DHIS2 API.}

\item{call}{The caller environment.}
}
\value{
A tibble with detailed information, including:
\itemize{
\item Geographical identifiers (country, subnational, district, facility, depending on level)
\item Reporting period (month, year, fiscal year)
\item The reporting metric can be REPORTING_RATE, REPORTING_RATE_ON_TIME, ACTUAL_REPORTS, ACTUAL_REPORTS_ON_TIME, EXPECTED_REPORTS.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\code{get_data_sets_by_level()} fetches the data set reporting metrics. The metric
can be REPORTING_RATE, REPORTING_RATE_ON_TIME, ACTUAL_REPORTS, ACTUAL_REPORTS_ON_TIME, EXPECTED_REPORTS.
}
\examples{
\dontshow{if (khis_has_cred()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# The MoH 745 Cancer Screening Program Monthly Summary Form
dataset_id = c('WWh5hbCmvND')

# Download data from February 2023 to current date
data <- get_data_sets_by_level(dataset_ids = dataset_id,
                               start_date = '2023-02-01')
data
\dontshow{\}) # examplesIf}
}
\seealso{
\itemize{
\item \code{\link[=get_organisations_by_level]{get_organisations_by_level()}} for getting the organisations units
\item \code{\link[=get_data_sets]{get_data_sets()}} for retrieving the data sets
}
}
