% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour.R
\name{colour}
\alias{colour}
\alias{color}
\title{Colour palette}
\usage{
colour(palette, reverse = FALSE, names = TRUE, ...)

color(palette, reverse = FALSE, names = TRUE, ...)
}
\arguments{
\item{palette}{A \code{\link{character}} string giving the name of
the palette to be used (see below).}

\item{reverse}{A \code{\link{logical}} scalar specifying if the resulting
vector of colours should be reversed.}

\item{names}{A \code{\link{logical}} scalar specifying if the names of the
colours should be kept in the resulting vector.}

\item{...}{Further arguments passed to \code{\link[grDevices]{colorRampPalette}}.}
}
\value{
A palette function that when called with a single integer argument
 (the number of levels) returns a vector of colours.
}
\description{
Provides qualitative, diverging and sequential colour palettes.
}
\section{Paul Tol's Colour Schemes}{

 The following palettes are available (maximum supported colours in brackets):
 \describe{
  \item{Qualitative data}{bright (7), vibrant (7), muted (9), light (9)}
  \item{Diverging data}{sunset (11), BuRd (9), PRGn (9)}
  \item{Sequential data}{YlOrBr (9), rainbow (23), smooth rainbow (34)}
 }
}

\section{Scientific Colour Schemes}{

 The following palettes are available:
 \describe{
  \item{stratigraphy}{International Chronostratigraphic Chart}
  \item{soil}{FAO Reference Soil Groups}
 }
}

\examples{
library("scales")

# Paul Tol's colour schemes
# Qualitative data
show_col(colour("bright")(7))
show_col(colour("vibrant")(7))
show_col(colour("muted")(9))
show_col(colour("light")(9))
show_col(colour("rainbow")(14))
show_col(colour("rainbow")(23))
# Diverging data
show_col(colour("sunset")(11))
show_col(colour("BuRd")(9))
show_col(colour("PRGn")(9))
# Sequential data
show_col(colour("YlOrBr")(9))
show_col(colour("smooth rainbow")(34))

# Scientific colour schemes
# Geologic Timescale
show_col(colour("stratigraphy")(175))
# FAO soil reference groups
show_col(colour("soil")(24))
}
\references{
Jones, A., Montanarella, L. & Jones, R. (Ed.) (2005). \emph{Soil atlas of
 Europe}. Luxembourg: European Commission, Office for Official Publications
 of the European Communities. 128 pp. ISBN: 92-894-8120-X.

 Tol, Paul (2018). \emph{Colour Schemes}. SRON. Technical Note No.
 SRON/EPS/TN/09-002. URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}

 \href{https://www.ccgm.org}{Commission for the Geological Map of the World}
}
\author{
N. Frerebeau
}
