% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_smoothrainbow}
\alias{scale_tol_smoothrainbow}
\alias{scale_colour_smoothrainbow}
\alias{scale_color_smoothrainbow}
\alias{scale_fill_smoothrainbow}
\alias{scale_edge_colour_smoothrainbow}
\alias{scale_edge_color_smoothrainbow}
\alias{scale_edge_fill_smoothrainbow}
\title{Paul Tol's \emph{smooth rainbow} Sequential Colour Scheme}
\usage{
scale_colour_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "fill"
)

scale_edge_colour_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "edge_colour"
)

scale_edge_color_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "edge_colour"
)

scale_edge_fill_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "edge_fill"
)
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{range}{A length-two \code{\link{numeric}} vector specifying the
fraction of the scheme's colour domain to keep.}

\item{discrete}{A \code{\link{logical}} scalar: should the colour scheme be
used as a discrete scale? If \code{TRUE}, it is a departure from Paul Tol's
recommendations and likely a very poor use of colour.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Paul Tol's \emph{smooth rainbow} Sequential Colour Scheme
}
\section{Interpolation}{

If more colors than defined are needed from a given scheme, the colour
coordinates are linearly interpolated to provide a continuous version of the
scheme, with the exception of the \verb{discrete rainbow} scheme (see below).

Note that the default colour for \code{NA} can be overridden by passing
a value to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.
}

\section{Rainbow colour scheme}{

As a general rule, ordered data should not be represented using a rainbow
scheme. There are three main arguments against such use (Tol 2018):
\itemize{
\item{The spectral order of visible light carries no inherent magnitude
message.}
\item{Some bands of almost constant hue with sharp transitions between
them, can be perceived as jumps in the data.}
\item{Colour-blind people have difficulty distinguishing some colours of
the rainbow.}
}
If such use cannot be avoided, Paul Tol's technical note provides two colour
schemes that are reasonably clear in colour-blind vision. To remain
colour-blind safe, these two schemes must comply with the following
conditions:
\describe{
\item{\code{discreterainbow}}{This scheme must not be interpolated.}
\item{\code{smoothrainbow}}{This scheme does not have to be used over the full
range.}
}
}

\examples{
data(faithfuld, package = "ggplot2")

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_YlOrBr()

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_iridescent(reverse = TRUE)

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_smoothrainbow(range = c(0.25, 1))
}
\references{
Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.1.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other sequential colour schemes: 
\code{\link{scale_crameri_acton}},
\code{\link{scale_crameri_bamako}},
\code{\link{scale_crameri_batlowK}},
\code{\link{scale_crameri_batlowW}},
\code{\link{scale_crameri_batlow}},
\code{\link{scale_crameri_bilbao}},
\code{\link{scale_crameri_buda}},
\code{\link{scale_crameri_davos}},
\code{\link{scale_crameri_devon}},
\code{\link{scale_crameri_grayC}},
\code{\link{scale_crameri_hawaii}},
\code{\link{scale_crameri_imola}},
\code{\link{scale_crameri_lajolla}},
\code{\link{scale_crameri_lapaz}},
\code{\link{scale_crameri_nuuk}},
\code{\link{scale_crameri_oslo}},
\code{\link{scale_crameri_tokyo}},
\code{\link{scale_crameri_turku}},
\code{\link{scale_tol_YlOrBr}},
\code{\link{scale_tol_discreterainbow}},
\code{\link{scale_tol_iridescent}}

Other Paul Tol's colour schemes: 
\code{\link{scale_tol_BuRd}},
\code{\link{scale_tol_PRGn}},
\code{\link{scale_tol_YlOrBr}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_discreterainbow}},
\code{\link{scale_tol_highcontrast}},
\code{\link{scale_tol_iridescent}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_sunset}},
\code{\link{scale_tol_vibrant}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
\concept{sequential colour schemes}
