% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_discreterainbow}
\alias{scale_tol_discreterainbow}
\alias{scale_colour_discreterainbow}
\alias{scale_color_discreterainbow}
\alias{scale_fill_discreterainbow}
\alias{scale_edge_colour_discreterainbow}
\alias{scale_edge_color_discreterainbow}
\alias{scale_edge_fill_discreterainbow}
\title{Paul Tol's \emph{discrete rainbow} Sequential Color Scheme}
\usage{
scale_colour_discreterainbow(..., reverse = FALSE, aesthetics = "colour")

scale_color_discreterainbow(..., reverse = FALSE, aesthetics = "colour")

scale_fill_discreterainbow(..., reverse = FALSE, aesthetics = "fill")

scale_edge_colour_discreterainbow(
  ...,
  reverse = FALSE,
  aesthetics = "edge_colour"
)

scale_edge_color_discreterainbow(
  ...,
  reverse = FALSE,
  aesthetics = "edge_colour"
)

scale_edge_fill_discreterainbow(..., reverse = FALSE, aesthetics = "edge_fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} scale.
}
\description{
Paul Tol's \emph{discrete rainbow} Sequential Color Scheme
}
\section{Sequential Color Schemes}{

If more colors than defined are needed from a given scheme, the color
coordinates are linearly interpolated to provide a continuous version of the
scheme.

\tabular{lll}{
\strong{Palette}       \tab \strong{Max.} \tab \strong{NA value} \cr
\code{YlOrBr}          \tab 9        \tab #888888      \cr
\code{iridescent}      \tab 23       \tab #999999      \cr
\code{discreterainbow} \tab 23       \tab #777777      \cr
\code{smoothrainbow}   \tab 34       \tab #666666      \cr
}
}

\section{Rainbow Color Scheme}{

As a general rule, ordered data should not be represented using a rainbow
scheme. There are three main arguments against such use (Tol 2018):
\itemize{
\item{The spectral order of visible light carries no inherent magnitude
message.}
\item{Some bands of almost constant hue with sharp transitions between
them, can be perceived as jumps in the data.}
\item{Color-blind people have difficulty distinguishing some colors of
the rainbow.}
}
If such use cannot be avoided, Paul Tol's technical note provides two color
schemes that are reasonably clear in color-blind vision. To remain
color-blind safe, these two schemes must comply with the following
conditions:
\describe{
\item{\code{discreterainbow}}{This scheme must not be interpolated.}
\item{\code{smoothrainbow}}{This scheme does not have to be used over the full
range.}
}
}

\examples{
data(mpg, package = "ggplot2")

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_bright()

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_vibrant()

data(diamonds, package = "ggplot2")

ggplot2::ggplot(diamonds, ggplot2::aes(clarity, fill = cut)) +
  ggplot2::geom_bar() +
  scale_fill_muted()
}
\references{
Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.1.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other qualitative color schemes: 
\code{\link{scale_colour_land}()},
\code{\link{scale_colour_soil}()},
\code{\link{scale_colour_stratigraphy}()},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_highcontrast}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_vibrant}}

Other Paul Tol's color schemes: 
\code{\link{scale_tol_BuRd}},
\code{\link{scale_tol_PRGn}},
\code{\link{scale_tol_YlOrBr}},
\code{\link{scale_tol_bright}},
\code{\link{scale_tol_dark}},
\code{\link{scale_tol_highcontrast}},
\code{\link{scale_tol_incandescent}},
\code{\link{scale_tol_iridescent}},
\code{\link{scale_tol_light}},
\code{\link{scale_tol_mediumcontrast}},
\code{\link{scale_tol_muted}},
\code{\link{scale_tol_nightfall}},
\code{\link{scale_tol_pale}},
\code{\link{scale_tol_smoothrainbow}},
\code{\link{scale_tol_sunset}},
\code{\link{scale_tol_vibrant}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's color schemes}
\concept{qualitative color schemes}
