% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_crameri.R
\name{scale_crameri_diverging}
\alias{scale_crameri_diverging}
\alias{scale_colour_broc}
\alias{scale_color_broc}
\alias{scale_fill_broc}
\alias{scale_colour_cork}
\alias{scale_color_cork}
\alias{scale_fill_cork}
\alias{scale_colour_vik}
\alias{scale_color_vik}
\alias{scale_fill_vik}
\alias{scale_colour_lisbon}
\alias{scale_color_lisbon}
\alias{scale_fill_lisbon}
\alias{scale_colour_tofino}
\alias{scale_color_tofino}
\alias{scale_fill_tofino}
\alias{scale_colour_berlin}
\alias{scale_color_berlin}
\alias{scale_fill_berlin}
\alias{scale_colour_roma}
\alias{scale_color_roma}
\alias{scale_fill_roma}
\alias{scale_colour_bam}
\alias{scale_color_bam}
\alias{scale_fill_bam}
\alias{scale_colour_vanimo}
\alias{scale_color_vanimo}
\alias{scale_fill_vanimo}
\title{Fabio Crameri's Diverging Colour Schemes for \pkg{ggplot2}}
\source{
Crameri, F. (2021). Scientific colour maps. \emph{Zenodo}, v7.0.
\doi{10.5281/zenodo.4491293}
}
\usage{
scale_colour_broc(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_broc(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_broc(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_cork(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_cork(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_cork(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_vik(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_vik(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_vik(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_lisbon(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_lisbon(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_lisbon(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_tofino(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_tofino(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_tofino(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_berlin(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_berlin(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_berlin(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_roma(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_roma(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_roma(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_bam(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_bam(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_bam(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_vanimo(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_vanimo(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_vanimo(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  midpoint = 0,
  discrete = FALSE,
  aesthetics = "fill"
)
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{range}{A length-two \code{\link{numeric}} vector specifying the
fraction of the scheme's colour domain to keep.}

\item{midpoint}{A length-one \code{\link{numeric}} vector giving the midpoint
(in data value) of the diverging scale. Defaults to \code{0}.}

\item{discrete}{A \code{\link{logical}} scalar: should the colour scheme be
used as a discrete scale?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Provides diverging colour scales from Fabio Crameri's \emph{Scientific colour}.
}
\details{
If more colours than defined are needed from a given scheme, the colour
coordinates are linearly interpolated to provide a continuous version of the
scheme.
Note that the default colour for \code{NA} can be overridden by passing
a value to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.

Available schemes:
\itemize{
\item \code{broc}
\item \code{cork}
\item \code{vik}
\item \code{lisbon}
\item \code{tofino}
\item \code{berlin}
\item \code{roma}
\item \code{bam}
\item \code{vanimo}
}
}
\examples{
data(economics, package = "ggplot2")

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_colour_broc(reverse = TRUE, midpoint = 12000)

ggplot2::ggplot(economics, ggplot2::aes(psavert, pce, colour = unemploy)) +
  ggplot2::geom_point() +
  scale_colour_berlin(midpoint = 9000)
}
\references{
Crameri, F. (2018). Geodynamic diagnostics, scientific visualisation and
StagLab 3.0. \emph{Geosci. Model Dev.}, 11, 2541-2562.
\doi{10.5194/gmd-11-2541-2018}

Crameri, F., Shephard, G. E. & Heron, P. J. (2020). The misuse of colour in
science communication. \emph{Nature Communications}, 11, 5444.
\doi{10.1038/s41467-020-19160-7}
}
\seealso{
Other colour-blind safe colour schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_crameri_sequential}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_diverging}},
\code{\link{scale_tol_sequential}}

Other diverging colour schemes: 
\code{\link{scale_tol_diverging}}

Other Fabio Crameri's colour schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_crameri_sequential}}
}
\author{
N. Frerebeau
}
\concept{Fabio Crameri's colour schemes}
\concept{colour-blind safe colour schemes}
\concept{diverging colour schemes}
