% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colour.R
\name{ramp}
\alias{ramp}
\title{Colour Ramp}
\usage{
ramp(x, palette, midpoint = NULL, ...)
}
\arguments{
\item{x}{A \code{\link{numeric}} vector to be mapped to colours.}

\item{palette}{A \code{\link{character}} string giving the name of the palette to be
used (see \code{\link[=colour]{colour()}}).}

\item{midpoint}{A \code{\link{numeric}} value specifying the midpoint of \code{x}. If not
\code{NULL}, \code{x} will be rescaled to have the specified \code{midpoint}.}

\item{...}{Further arguments passed to \code{\link[=colour]{colour()}}.}
}
\value{
A palette function with the following attributes, that when called
with a single argument (the number of levels, e.g. the \code{breaks} returned by
\code{\link[=hist]{hist()}}) returns a vector of colours.
}
\description{
Provides a colour scheme that map a \code{numeric} vector to colours.
}
\examples{
## Visualize a simple DEM model

## Distribution of elevation values
elevation <- hist(volcano)

## Where are breaks?
elevation$breaks

## No rescaling
ramp_default <- ramp(elevation$breaks, palette = "BuRd")(10)
image(volcano, col = ramp_default)
legend("topright", legend = attr(ramp_default, "breaks"), fill = ramp_default)

## Rescale to midpoint
ramp_160 <- ramp(elevation$breaks, palette = "BuRd", midpoint = 160)(10)
image(volcano, col = ramp_160)
legend("topright", legend = attr(ramp_160, "breaks"), fill = ramp_160)
}
\seealso{
Other colour palettes: 
\code{\link{colour}()},
\code{\link{info}()},
\code{\link{scale_picker}}
}
\author{
N. Frerebeau
}
\concept{colour palettes}
\keyword{color}
