% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service.general.R
\name{service.is.param_possible}
\alias{service.is.param_possible}
\title{Service functions for data check which could be applied in any function of the package or externally}
\usage{
service.is.param_possible(param2check, possible_params)
}
\arguments{
\item{param2check}{Numeric value or character string. The single value to be verified.}

\item{possible_params}{Vector. The vector of values which contains all possible values.}
}
\value{
logic returns TRUE if argument param2check is foundin possible values possible_params, and FALSE if it is not.
}
\description{
Service functions for data check which could be applied in any function of the package or externally
}
\details{
Verifies whether the single value is among the values of the vector. 
Function is useful to check whether the argument of the function defined by the user is among the possible arguments recognized inside the function.

Programming: Boris Bikbov \email{boris@bikbov.ru}.
}
\examples{
possible_params = c("KDPI", " KDRI_Rao", "KDRI_median")
service.is.param_possible("KDZO", possible_params) # return FALSE
service.is.param_possible("KDPI", possible_params) # return TRUE
}
