% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram_by_group.R
\name{histogram_by_group}
\alias{histogram_by_group}
\title{Histogram by group}
\usage{
histogram_by_group(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  order_of_groups_top_to_bot = NULL,
  number_of_bins = 40,
  space_between_histograms = 0.15,
  draw_baseline = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the independent variable}

\item{dv_name}{name of the dependent variable}

\item{order_of_groups_top_to_bot}{a character vector indicating
the desired presentation order of levels in the independent variable
(from the top to bottom). Omitting a group in this argument will
remove the group in the set of histograms.}

\item{number_of_bins}{number of bins for the histograms (default = 40)}

\item{space_between_histograms}{space between histograms
(minimum = 0, maximum = 1, default = 0.15)}

\item{draw_baseline}{logical. Should the baseline and the trailing
lines to either side of the histogram be drawn? (default = FALSE)}
}
\value{
the output will be a set of vertically arranged histograms
(a ggplot object), i.e., one histogram for each level of the
independent variable.
}
\description{
Creates histograms by group to compare distributions.
}
\details{
The following package(s) must be installed prior to running this function:
Package 'ggridges' v0.5.3 (or possibly a higher version) by
Claus O. Wilke (2021),
\url{https://cran.r-project.org/package=ggridges}
}
\examples{
histogram_by_group(data = mtcars, iv_name = "cyl", dv_name = "mpg")
histogram_by_group(
  data = mtcars, iv_name = "cyl", dv_name = "mpg",
  order_of_groups_top_to_bot = c("8", "4"), number_of_bins = 10,
  space_between_histograms = 0.5
)
histogram_by_group(
data = iris, iv_name = "Species", dv_name = "Sepal.Length")
}
