% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histogram_w_outlier_bins.R
\name{histogram_w_outlier_bins}
\alias{histogram_w_outlier_bins}
\title{Histogram with outlier bins}
\usage{
histogram_w_outlier_bins(
  vector = NULL,
  bin_cutoffs = NULL,
  outlier_bin_left = TRUE,
  outlier_bin_right = TRUE,
  x_tick_marks = NULL,
  x_tick_mark_labels = NULL,
  y_tick_marks = NULL,
  outlier_bin_fill_color = "coral",
  non_outlier_bin_fill_color = "cyan4",
  border_color = "black",
  y_axis_title_vjust = 0.85,
  x_axis_title = NULL,
  y_axis_title = NULL,
  notify_na_count = NULL,
  plot_proportion = TRUE,
  plot_frequency = FALSE,
  mean = TRUE,
  ci = TRUE,
  median = TRUE,
  median_position = 15,
  error_bar_size = 3
)
}
\arguments{
\item{vector}{a numeric vector}

\item{bin_cutoffs}{cutoff points for bins}

\item{outlier_bin_left}{logical. Should the leftmost bin treated
as an outlier bin? (default = TRUE)}

\item{outlier_bin_right}{logical. Should the rightmost bin treated
as an outlier bin? (default = TRUE)}

\item{x_tick_marks}{a vector of values at which to place tick marks
on the x axis. Note that the first bar spans from 0.5 to 1.5,
second bar from 1.5 to 2.5, ... nth bar from n - 0.5 to n + 0.5.
See the example. By default, tick marks will be placed at every
cutoff point for bins}

\item{x_tick_mark_labels}{a character vector to label tick marks.
By default, the vector of cutoff points for bins will also be
used as labels.}

\item{y_tick_marks}{a vector of values at which to place tick marks
on the y axis (e.g., setting \code{y_tick_marks = seq(0, 10, 5)} will
put tick marks at 0, 5, and 10.)}

\item{outlier_bin_fill_color}{color to fill inside of the
outlier bins (default = "coral")}

\item{non_outlier_bin_fill_color}{color to fill inside of the
non-outlier bins (default = "cyan4")}

\item{border_color}{color for borders of the bins (default = "black")}

\item{y_axis_title_vjust}{position of the y axis title (default = 0.85).}

\item{x_axis_title}{title for x axis (default = "Value"). If
\code{x_axis_title = FALSE}, x axis title will be removed from the plot.}

\item{y_axis_title}{title for y axis. By default, it will be either
"Proportion" or "Count".}

\item{notify_na_count}{if \code{TRUE}, notify how many observations
were removed due to missing values. By default, NA count will be printed
only if there are any NA values.}

\item{plot_proportion}{logical. Should proportions be plotted,
as opposed to frequencies? (default = TRUE)}

\item{plot_frequency}{logical. Should frequencies be plotted,
as opposed to proportions? (default = FALSE).
If \code{plot_frequency = TRUE}, \code{plot_proportion} will
switch to be FALSE.}

\item{mean}{logical. Should mean marked on the histogram?
(default = TRUE)}

\item{ci}{logical. Should 95\% confidence interval marked on the histogram?
(default = TRUE)}

\item{median}{logical. Should median marked on the histogram?
(default = TRUE)}

\item{median_position}{position of the median label as a percentage of
height of the tallest bin (default = 15)}

\item{error_bar_size}{size of the error bars (default = 3)}
}
\value{
a ggplot object
}
\description{
Create a histogram with outlier bins
}
\examples{
histogram_w_outlier_bins(vector = 1:100, bin_cutoffs = seq(0, 100, 10))
histogram_w_outlier_bins(vector = 0:89, bin_cutoffs = seq(0, 90, 10),
x_tick_marks = seq(0.5, 9.5, 3), x_tick_mark_labels = seq(0, 90, 30))
histogram_w_outlier_bins(vector = 1:10, bin_cutoffs = seq(0, 10, 2.5))
histogram_w_outlier_bins(vector = 1:5, bin_cutoffs = seq(0, 10, 2.5))
histogram_w_outlier_bins(vector = 1:15, bin_cutoffs = c(5.52, 10.5))
}
