% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/floodlight_2_by_continuous_for_logistic.R
\name{floodlight_2_by_continuous_logistic}
\alias{floodlight_2_by_continuous_logistic}
\title{Floodlight 2 by Continuous for a Logistic Regression}
\usage{
floodlight_2_by_continuous_logistic(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  mod_name = NULL,
  interaction_p_include = TRUE,
  iv_level_order = NULL,
  dv_level_order = NULL,
  jn_points_disregard_threshold = NULL,
  output = "reg_lines_plot",
  num_of_spotlights = 20,
  jitter_x_percent = 0,
  jitter_y_percent = 5,
  dot_alpha = 0.3,
  dot_size = 6,
  interaction_p_value_font_size = 8,
  jn_point_font_size = 8,
  jn_point_label_hjust = NULL,
  interaction_p_vjust = -3,
  plot_margin = ggplot2::unit(c(75, 7, 7, 7), "pt"),
  legend_position = "right",
  line_types_for_pred_values = c("solid", "dashed"),
  line_thickness_for_pred_values = 2.5,
  jn_line_types = c("solid", "solid"),
  jn_line_thickness = 1.5,
  sig_region_color = "green",
  sig_region_alpha = 0.08,
  nonsig_region_color = "gray",
  nonsig_region_alpha = 0.08,
  x_axis_title = NULL,
  y_axis_title = NULL,
  legend_title = NULL,
  round_decimals_int_p_value = 3,
  round_jn_point_labels = 2
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the binary independent variable}

\item{dv_name}{name of the binary dependent variable}

\item{mod_name}{name of the continuous moderator variable}

\item{interaction_p_include}{logical. Should the plot include a
p-value for the interaction term?}

\item{iv_level_order}{order of levels in the independent
variable for legend. By default, it will be set as levels of the
independent variable ordered using R's base function \code{sort}.}

\item{dv_level_order}{order of levels in the dependent variable.
By default, it will be set as levels of the
dependent variable ordered using R's base function \code{sort}.}

\item{jn_points_disregard_threshold}{the Minimum Distance in
the unit of the moderator variable that will be used for various purposes,
such as (1) to disregard the second Johnson-Neyman point
that is different from the first Johnson-Neyman (JN) point by
less than the Minimum Distance; (2) to determine regions of
significance, which will calculate the p-value of the IV's effect
(the focal dummy variable's effect) on DV at a candidate
JN point + / - the Minimum Distance.
This input is hard to explain, but a user can enter a really low value
for this argument (e.g., \code{jn_points_disregard_threshold = 0.1}
for a moderator measured on a 100-point scale) or use the default.
By default, \code{
jn_points_disregard_threshold = range of the moderator / 10000}
For example, if the observed moderator values range from 1 to 7
(because it is a 7-point scale), then \code{
jn_points_disregard_threshold = (7 - 1) / 10000 = 0.0006}}

\item{output}{type of output (default = "reg_lines_plot").
Possible inputs: "interactions_pkg_results", "simple_effects_plot",
"jn_points", "regions", "reg_lines_plot"}

\item{num_of_spotlights}{How many spotlight analyses should be
conducted to plot the predicted values at various values of the
moderator? (default = 20)}

\item{jitter_x_percent}{horizontally jitter dots by a percentage of the
range of x values (default = 0)}

\item{jitter_y_percent}{vertically jitter dots by a percentage of the
range of y values (default = 5)}

\item{dot_alpha}{opacity of the dots (0 = completely transparent,
1 = completely opaque). By default, \code{dot_alpha = 0.3}}

\item{dot_size}{size of the dots (default = 6)}

\item{interaction_p_value_font_size}{font size for the interaction
p value (default = 8)}

\item{jn_point_font_size}{font size for Johnson-Neyman point labels
(default = 8)}

\item{jn_point_label_hjust}{a vector of hjust values for
Johnson-Neyman point labels. By default, the hjust value will be 0.5 for
all the points.}

\item{interaction_p_vjust}{By how much should the label for the
interaction p-value be adjusted vertically?
By default, \code{interaction_p_vjust = -3})}

\item{plot_margin}{margin for the plot
By default \code{plot_margin = ggplot2::unit(c(75, 7, 7, 7), "pt")}}

\item{legend_position}{position of the legend (default = "right").
If \code{legend_position = "none"}, the legend will be removed.}

\item{line_types_for_pred_values}{types of the lines for plotting
the predicted values
By default, \code{line_types_for_pred_values = c("solid", "dashed")}}

\item{line_thickness_for_pred_values}{thickness of the lines
for plotting the predicted values (default = 2.5)}

\item{jn_line_types}{types of the lines for Johnson-Neyman points.
By default, \code{jn_line_types = c("solid", "solid")}}

\item{jn_line_thickness}{thickness of the lines at Johnson-Neyman points
(default = 1.5)}

\item{sig_region_color}{color of the significant region, i.e., range(s)
of the moderator variable for which simple effect of the independent
variable on the dependent variable is statistically significant.}

\item{sig_region_alpha}{opacity for \code{sig_region_color}.
(0 = completely transparent, 1 = completely opaque).
By default, \code{sig_region_alpha = 0.08}}

\item{nonsig_region_color}{color of the non-significant region,
i.e., range(s) of the moderator variable for which simple effect of
the independent variable on the dependent variable is not
statistically significant.}

\item{nonsig_region_alpha}{opacity for \code{nonsig_region_color}.
(0 = completely transparent, 1 = completely opaque).
By default, \code{nonsig_region_alpha = 0.08}}

\item{x_axis_title}{title of the x axis. By default, it will be set
as input for \code{mod_name}. If \code{x_axis_title = FALSE}, it will
be removed.}

\item{y_axis_title}{title of the y axis. By default, it will be set
as input for \code{dv_name}. If \code{y_axis_title = FALSE}, it will
be removed.}

\item{legend_title}{title of the legend. By default, it will be set
as input for \code{iv_name}. If \code{legend_title = FALSE}, it will
be removed.}

\item{round_decimals_int_p_value}{To how many digits after the
decimal point should the p value for the interaction term be
rounded? (default = 3)}

\item{round_jn_point_labels}{To how many digits after the
decimal point should the jn point labels be rounded? (default = 2)}
}
\description{
Conduct a floodlight analysis for a logistic regression with a
2 x Continuous design involving a binary dependent variable.
}
\details{
See the following reference(s):
Spiller et al. (2013) \doi{10.1509/jmr.12.0420}
Kim (2023) \url{https://jinkim.science/docs/floodlight.pdf}
}
\examples{
\donttest{
floodlight_2_by_continuous_logistic(
data = mtcars,
iv_name = "am",
dv_name = "vs",
mod_name = "mpg")
# adjust the number of spotlights
# (i.e., predict values at only 4 values of the moderator)
floodlight_2_by_continuous_logistic(
data = mtcars,
iv_name = "am",
dv_name = "vs",
mod_name = "mpg",
num_of_spotlights = 4)
}
}
