% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_kinpairs.R
\name{vector_to_kinpair}
\alias{vector_to_kinpair}
\title{Convert vector of kin separation distances to \code{\link{KinPairData}} class}
\usage{
vector_to_kinpair(vect, kinship = NULL, lifestage = NULL)
}
\arguments{
\item{vect}{vector of kinpair distances}

\item{kinship}{character or character vector containing kinship categories of kinpairs}

\item{lifestage}{character or character vector containing lifestages of kinpairs}
}
\value{
returns valid \code{KinPairData} object.
}
\description{
Function takes at minimum a (numeric) vector of distances between related kinpairs, and
returns a \code{KinPairData} object. Optional parameters can assign kinship and lifestage values to the
returned object.
}
\examples{
vector_to_kinpair(1:10, "FS", "immature")
}
\seealso{
Other import_functions: 
\code{\link{csv_to_kinpair}()},
\code{\link{df_to_kinpair}()},
\code{\link{read_kindata}()},
\code{\link{tsv_to_kinpair}()}
}
\concept{import_functions}
