\name{klausur.mufo}
\alias{klausur.mufo}
\title{Evaluate multiple choice tests with several test forms}
\usage{
  klausur.mufo(data, marks = NULL, mark.labels = NULL,
  items = NULL, wght = NULL, score = "solved", matn = NULL,
  na.rm = TRUE, cronbach = TRUE, item.analysis = TRUE)
}
\arguments{
  \item{data}{An object of class
  \code{\link[klausuR]{klausuR.answ-class}}.}

  \item{marks}{A vector assigning marks to points achieved
  (see details). Alternatively, set it to \code{"suggest"}
  to let
  \code{\link[klausuR:klausur.gen.marks]{klausur.gen.marks}}
  calculate suggestions under the assumption of normal
  distribution. If \code{NULL}, this value must be set in
  the \code{data} object.}

  \item{mark.labels}{If \code{marks="suggest"}, use these
  as the marks you want to give.}

  \item{items}{Indices of a subset of variables in
  \code{answ} to be taken as items.}

  \item{wght}{A vector with weights for each item (named
  also according to \code{Item###}). If \code{NULL}, the
  value from the \code{data} object will be used.}

  \item{score}{Specify the scoring policy, must be one of
  \code{"solved"} (default), \code{"partial"},
  \code{"liberal"}, \code{"NR"}, \code{"ET"},
  \code{"NRET"}, or \code{"NRET+"}.}

  \item{matn}{A matriculation number of a subject, to
  receive detailed results for that subject.}

  \item{na.rm}{Logical, whether cases with NAs should be
  ignored in \code{data}. Defaults to TRUE.}

  \item{cronbach}{Logical. If TRUE, Cronbach's alpha will
  be calculated.}

  \item{item.analysis}{Logical. If TRUE, some usual item
  statistics like difficulty and discriminatory power will
  be calculated. If \code{cronbach} is TRUE, too, it will
  include the alpha values if each item was deleted.}
}
\value{
  An object of class
  \code{\link[klausuR]{klausuR.mult-class}} with the
  following slots. \item{forms}{A character vector naming
  all test forms} \item{results.part}{A list of objects of
  class \code{klausuR}, holding all partial results}
  \item{results.glob}{An object of class \code{klausuR}
  with the global results} Not all slots are shown by
  default (refer to \code{\link[klausuR:show]{show}}).
}
\description{
  This function can be used to evaluate tests that have
  several test forms. Please be aware that its results only
  make sense if each test form uses the same items, only in
  a different order.
}
\details{
  Firstly, \code{klausur.mufo} will compute partial results
  for each parallel form, and in the end combine these to
  global results. Cronbach alpha and item analysis will be
  calculated for all subjects accordingly, therefore the
  test items of all tests will be re-ordered to fit the
  order of the first given test form (this does not apply
  to the partial results).

  The parameters are mostly the same as those for
  \code{\link[klausuR:klausur]{klausur}}. However, in the
  \code{data} object the slot \code{corr} must also contain
  \code{corr.key}, to communicate the order of items in
  each test form, and the slot \code{id} needs one
  additional variable called \code{Form}.

  An example: You have prepared a test in two different
  parallel forms "A" an "B", So in addition to the
  variables in \code{data@id} you need to create a variable
  called \code{Form}, to document which test subject was
  given which test form. Since form "B" holds the same
  items as form "A", only in a different order, we only
  need to define these positions and we're done. Therefore
  \code{corr.key} must be a matrix or data.frame, again
  with a column called "Form", one column for each item,
  and one row of data for each test form. That is, you'd
  need one row for test form "A" and one for test form "B",
  giving an index for each item where it is placed in the
  form. For "A" this is simply ascending numbers from 1 to
  how many questions you asked, but for row "B" each number
  indicates at which position an item of "A" is to be
  found. See the example below.
}
\examples{
# this will create the data.frame "antworten.mufo"
# and the matrix "corr.key"
data(antworten.mufo)

# vector with correct answers:
richtig <- c(Item01=3, Item02=2, Item03=2, Item04=2, Item05=4,
Item06=3, Item07=4, Item08=1, Item09=2, Item10=2, Item11=4,
Item12=4, Item13=2, Item14=3, Item15=2, Item16=3, Item17=4,
Item18=4, Item19=3, Item20=5, Item21=3, Item22=3, Item23=1,
Item24=3, Item25=1, Item26=3, Item27=5, Item28=3, Item29=4,
Item30=4, Item31=13, Item32=234)

# vector with assignement of marks:
notenschluessel <- c()
# scheme of assignments: marks[points_from:to] <- mark
notenschluessel[0:12]  <- 5.0
notenschluessel[13:15] <- 4.0
notenschluessel[16:18] <- 3.7
notenschluessel[19:20] <- 3.3
notenschluessel[21]    <- 3.0
notenschluessel[22]    <- 2.7
notenschluessel[23]    <- 2.3
notenschluessel[24]    <- 2.0
notenschluessel[25:26] <- 1.7
notenschluessel[27:29] <- 1.3
notenschluessel[30:32] <- 1.0

# now combine all test data into one object of class klausur.answ
mufo.data.obj <- klausur.data(answ=antworten.mufo, corr=richtig, marks=notenschluessel, corr.key=corr.key)
# expect some warnings here, because some items have no variance
# in their subtest results, hence item analysis fails on them
klsr.mufo.obj <- klausur.mufo(mufo.data.obj)
}
\author{
  m.eik michalke \email{meik.michalke@uni-duesseldorf.de}
}
\seealso{
  \code{\link[klausuR:klausur]{klausur}},
  \code{\link[klausuR:klausur.data]{klausur.data}}
}
\keyword{misc}

