% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_mats.R
\name{SpMatrixCalc}
\alias{SpMatrixCalc}
\title{Calculate Seasonal Similarity Matrix}
\usage{
SpMatrixCalc(v, nPeriods)
}
\arguments{
\item{v}{numeric vector with the seasonal periods corresponding to each point in the response series}

\item{nPeriods}{numeric value representing the maximum value \code{v} can take on}
}
\value{
numeric matrix of Seasonal Similarities for the vector \code{v}
}
\description{
Generates and returns an nxn matrix by calculating the Seasonal Dissimilarity
(see \code{SeasonalAbsDissimilarity()}) for each possible pair of points in a vector
of seasonal periods, then converts Dissimilarity matrix to a Similarity matrix using 1/(D_p +1).
}
\examples{
SpMatrixCalc(c(1,2,4),4)

}
