# the plugin code was generated by this script
# you should not change the plugin code directly, but this script
# note: this script only creates objects in your workspace,
# *EXCEPT* for the last call, see below.

local({
# set the output directory to overwrite the actual plugin
output.dir <- tempdir()
overwrite <- TRUE
# if you set guess.getters to TRUE, the resulting code will need RKWard >= 0.6.0
guess.getter <- FALSE

menu.hierarchy <- list("analysis", "Text Analysis")

require(rkwarddev)

about.info <- rk.XML.about(
	name="koRpus",
	author=c(
		person(given="Meik", family="Michalke",
			email="meik.michalke@hhu.de", role=c("aut","cre"))),
	about=list(desc="RKWard GUI for the koRpus package.")
	)
dependencies.info <- rk.XML.dependencies(
	dependencies=list(rkward.min=ifelse(isTRUE(guess.getter), "0.6.0", "0.5.6"))
)


kRp.POS.radio.mode <- rk.XML.radio(label="Select operation mode", options=list(
		"Tokenize with tokenize()"=c(val="file", chk=TRUE),
		"Tokenize and tag with TreeTagger"=c(val="fileTreeTagger")
	)
)

kRp.POS.brw.TTroot <- rk.XML.browser(
	label="TreeTagger root folder:",
	type="dir"
)
kRp.POS.txt.TTroot <- rk.XML.text("The TreeTagger folder is the one containing the bin, cmd and lib folders")
kRp.POS.drp.TTroot <- rk.XML.dropdown(label="Text language:", options=list(
		"English"=c(val="en", chk=TRUE),
		"German (UTF-8)"=c(val="de-utf8"),
		"German"=c(val="de"),
		"Italian (UTF-8)"=c(val="it-utf8"),
		"Italian"=c(val="it"),
		"Spanish (UTF-8)"=c(val="es-utf8"),
		"Spanish"=c(val="es"),
		"Russian (UTF-8)"=c(val="ru")
	)
)
kRp.POS.brw.text <- rk.XML.browser(
	label="Text to analyze:",
	filter="*.txt"
)
kRp.POS.frm.TT <- rk.XML.frame(
	kRp.POS.brw.TTroot,
	kRp.POS.txt.TTroot,
	kRp.POS.drp.TTroot,
	kRp.POS.brw.text
)

kRp.POS.chk.tkheadl <- rk.XML.cbox(
	label="Detect headlines (treated as sentences)",
	value="hline=TRUE"
)
kRp.POS.chk.tkparag <- rk.XML.cbox(
	label="Detect paragraphs",
	value="parag=TRUE"
)
kRp.POS.frm.tkopts <- rk.XML.frame(
	kRp.POS.chk.tkheadl,
	kRp.POS.chk.tkparag,
	label="tokenize() options"
)

kRp.POS.frm.show <- rk.XML.frame(
	kRp.POS.chk.show <- rk.XML.cbox(label="List tokenizing results in output (slow for long texts!)", value="tagged", id.name="showTagged")
)

kRp.POS.saveobj <- rk.XML.saveobj(label="Keep tagged text object", initial="tagged.text.obj", chk=TRUE, id.name="saveTaggedText")

kRp.dialog.POS <- rk.XML.dialog(
	rk.XML.row(
		rk.XML.col(
			kRp.POS.radio.mode,
			kRp.POS.frm.TT,
			kRp.POS.frm.tkopts,
			rk.XML.stretch(),
			kRp.POS.frm.show,
			kRp.POS.saveobj
		)
	),
	label="POS Tagging"
)

## logic section
kRp.POS.lgc.sect <- rk.XML.logic(
	kRp.POS.lgc.tagModeTokenize <- rk.XML.convert(sources=list(string=kRp.POS.radio.mode), mode=c(equals="file")),
	kRp.POS.lgc.tagModeTreeTagger <- rk.XML.convert(sources=list(string=kRp.POS.radio.mode), mode=c(equals="fileTreeTagger")),
	rk.XML.connect(governor=kRp.POS.lgc.tagModeTreeTagger, client=kRp.POS.txt.TTroot, set="visible"),
	rk.XML.connect(governor=kRp.POS.lgc.tagModeTreeTagger, client=kRp.POS.brw.TTroot, set="visible"),
	rk.XML.connect(governor=kRp.POS.lgc.tagModeTreeTagger, client=kRp.POS.brw.TTroot, set="required"),
	rk.XML.connect(governor=kRp.POS.lgc.tagModeTokenize, client=kRp.POS.frm.tkopts, set="visible")
)

## JavaScript
kRp.POS.js.lang <- rk.JS.vars("TTLang")
kRp.POS.js.calc <- rk.paste.JS(
# 	# these are probably fetched as boolean, ensure we get the character values
# 	kRp.POS.js.arr.tkheadl <- rk.JS.vars(kRp.POS.chk.tkheadl),
# 	kRp.POS.js.arr.tkparag <- rk.JS.vars(kRp.POS.chk.tkparag),
# 	kRp.POS.js.array <- rk.JS.array("detect", variables=list(kRp.POS.js.arr.tkheadl, kRp.POS.js.arr.tkparag)),
	kRp.POS.js.array <- rk.JS.array("detect", variables=list(kRp.POS.chk.tkheadl, kRp.POS.chk.tkparag)),
	ite(id(kRp.POS.drp.TTroot, " == \"de-utf8\""), id("var ", kRp.POS.js.lang, " = \"de\";"),
		ite(id(kRp.POS.drp.TTroot, " == \"es-utf8\""), id("var ", kRp.POS.js.lang, " = \"es\";"),
		ite(id(kRp.POS.drp.TTroot, " == \"it-utf8\""), id("var ", kRp.POS.js.lang, " = \"it\";"),
		id("var ", kRp.POS.js.lang, " = ", kRp.POS.drp.TTroot, ";")))
	),
	ite(id(kRp.POS.radio.mode, " == \"file\""),
		echo("tagged.text.obj <- tokenize(\"", kRp.POS.brw.text, "\", lang=\"", kRp.POS.js.lang, "\"", kRp.POS.js.array, ")\n"),
		echo("tagged.text.obj <- treetag(\"", kRp.POS.brw.text, "\", treetagger=\"manual\", lang=\"", kRp.POS.js.lang, "\", TT.options=list(path=\"", kRp.POS.brw.TTroot, "\", preset=\"", kRp.POS.drp.TTroot, "\"))\n")
	)

# 	if(radCustomTT == "file"){
# 		echo("tagged.text.obj <- tokenize(\""+txtToTag+"\", lang=\""+TTlang+"\""+tknzDetect+")\n");
# 	} else {
# 		echo("tagged.text.obj <- treetag(\""+txtToTag+"\", treetagger=\"manual\", lang=\""+TTlang+"\", TT.options=list(path=\""+TTroot+"\", preset=\""+TTpreset+"\"))\n");
# 	} else {};

)

### hyphenation

kRp.hyph.vars <- rk.XML.varselector(id.name="varsHyph")
kRp.hyph.data <- rk.XML.varslot(
	label="Tokenized text object (valid class: kRp.tagged)",
	source=kRp.hyph.vars,
	classes=c("kRp.tagged"),
	required=TRUE,
	id.name="varHyphenTagged"
)

kRp.hyph.frm.show <- rk.XML.frame(
	kRp.hyph.chk.show <- rk.XML.cbox(label="List hyphenation results in output", value="hyph", id.name="showHyphenation")
)
kRp.hyph.saveobj <- rk.XML.saveobj(label="Keep hyphenated text object", initial="hyphenated.text.obj", chk=TRUE, id.name="saveHyphen")

kRp.tab.hyph <- list(
	rk.XML.row(
		rk.XML.col(kRp.hyph.vars),
		rk.XML.col(
 			kRp.hyph.data,
			rk.XML.stretch(),
			kRp.hyph.frm.show,
			kRp.hyph.saveobj
		),
	id.name="rowHyph")
)

kRp.dialog.hyph <- rk.XML.dialog(kRp.tab.hyph, label="Hyphenation")

# 		<connect client="rowHyph.enabled" governor="chkCustomHyph.state" />
# 		<convert id="logicCustomHyphen" mode="equals" sources="radCustomHyph.string" standard="custom" />
# 		<connect client="frameCustomHyphen.visible" governor="logicCustomHyphen" />
# 		<connect client="varHyphenCustom.required" governor="logicCustomHyphen" />
# 		<convert id="logicSaveHyphen" mode="equals" sources="radCustomHyph.string" standard="auto" />
# 		<connect client="saveHyphen.enabled" governor="logicSaveHyphen" />


# 		echo("hyphenated.text.obj <- hyphen(tagged.text.obj, hyph.pattern=\""+TTlang+"\", quiet=TRUE)\n");
kRp.hyph.js.calc <- rk.paste.JS(
# 	echo("hyphenated.text.obj <- hyphen(tagged.text.obj, hyph.pattern=\"", TTlang, "\", quiet=TRUE)\n")
	echo("hyphenated.text.obj <- hyphen(", kRp.hyph.data, ", quiet=TRUE)\n")
)

kRp.hyph.component <- rk.plugin.component("Hyphenation",
	xml=list(
# 		logic=pd.lgc.sect,
		dialog=kRp.dialog.hyph),
 	js=list(
 		calculate=kRp.hyph.js.calc#,
# 		printout=pd.js.print
	),
	guess.getter=guess.getter,
	hierarchy=menu.hierarchy,
	create=c("xml", "js"))


## readability

kRp.rdb.chk.LIX <- rk.XML.cbox(label="Läsbarhetsindex (LIX)", value="LIX", chk=TRUE, id.name="LIX")
kRp.rdb.chk.RIX <- rk.XML.cbox(label="Readability Index (RIX)", value="RIX", chk=TRUE, id.name="RIX")
kRp.rdb.chk.ARI <- rk.XML.cbox(label="Automated Readability Index (ARI)", value="ARI", chk=TRUE, id.name="ARI")
kRp.rdb.chk.ARINRI <- rk.XML.cbox(label="ARI (NRI)", value="ARI.NRI", chk=TRUE, id.name="ARINRI")

kRp.rdb.chk.ColemanLiau <- rk.XML.cbox(label="Coleman-Liau", value="Coleman.Liau", chk=TRUE, id.name="ColemanLiau")
kRp.rdb.chk.DickesSteiwer <- rk.XML.cbox(label="Dickes-Steiwer Handformel", value="Dickes.Steiwer", chk=TRUE, id.name="DickesSteiwer")
kRp.rdb.chk.Fucks <- rk.XML.cbox(label="Fucks' Stilcharakteristik", value="Fucks", chk=TRUE, id.name="Fucks")
kRp.rdb.chk.DanielsonBrian <- rk.XML.cbox(label="Danielson-Bryan (D 1+2)", value="Danielson.Bryan", chk=TRUE, id.name="DanielsonBryan")

kRp.rdb.frm.rdb <- rk.XML.frame(
	rk.XML.row(
		rk.XML.col(
			kRp.rdb.chk.LIX,
			kRp.rdb.chk.RIX,
			kRp.rdb.chk.ARI,
			kRp.rdb.chk.ARINRI
		),
		rk.XML.col(
			kRp.rdb.chk.ColemanLiau,
			kRp.rdb.chk.DickesSteiwer,
			kRp.rdb.chk.Fucks,
			kRp.rdb.chk.DanielsonBrian
		)
	),
	id.name="frameReadabilityIndices"
)


kRp.rdb.chk.Flesch <- rk.XML.cbox(label="Flesch Reading Ease", value="Flesch", chk=TRUE, id.name="Flesch")
kRp.rdb.chk.FleschPSK <- rk.XML.cbox(label="Flesch Reading Ease (Powers-Sumner-Kearl)", value="Flesch.PSK", chk=TRUE, id.name="FleschPSK")
kRp.rdb.chk.FleschKincaid <- rk.XML.cbox(label="Flesch-Kincaid Grade Level", value="Flesch.Kincaid", chk=TRUE, id.name="FleschKincaid")
kRp.rdb.chk.FarrJenkinsPaterson <- rk.XML.cbox(label="Farr-Jenkins-Paterson", value="Farr.Jenkins.Paterson", chk=TRUE, id.name="FarrJenkinsPaterson")
kRp.rdb.chk.FarrJenkinsPatersonPSK <- rk.XML.cbox(label="Farr-Jenkins-Paterson (Powers-Sumner-Kearl)", value="Farr.Jenkins.Paterson.PSK", chk=TRUE, id.name="FarrJenkinsPatersonPSK")
kRp.rdb.chk.FOG <- rk.XML.cbox(label="Gunning FOG", value="FOG", chk=TRUE, id.name="FOG")
kRp.rdb.chk.FOGPSK <- rk.XML.cbox(label="FOG (Powers-Sumner-Kearl)", value="FOG.PSK", chk=TRUE, id.name="FOGPSK")
kRp.rdb.chk.FOGNRI <- rk.XML.cbox(label="FOG (NRI)", value="FOG.NRI", chk=TRUE, id.name="FOGNRI")
kRp.rdb.chk.SMOG <- rk.XML.cbox(label="SMOG", value="SMOG", chk=TRUE, id.name="SMOG")
kRp.rdb.chk.Qu <- rk.XML.cbox(label="Qu (SMOG de)", value="SMOG.de", chk=TRUE, id.name="Qu")

kRp.rdb.chk.WheelerSmith <- rk.XML.cbox(label="Wheeler-Smith", value="Wheeler.Smith", chk=TRUE, id.name="WheelerSmith")
kRp.rdb.chk.WheelerSmithDe <- rk.XML.cbox(label="Wheeler-Smith (de)", value="Wheeler.Smith.de", chk=TRUE, id.name="WheelerSmithDe")
kRp.rdb.chk.FORCAST <- rk.XML.cbox(label="FORCAST", value="FORCAST", chk=TRUE, id.name="FORCAST")
kRp.rdb.chk.Strain <- rk.XML.cbox(label="Strain Index", value="Strain", chk=TRUE, id.name="Strain")
kRp.rdb.chk.LinsearWrite <- rk.XML.cbox(label="Linsear Write", value="Linsear.Write", chk=TRUE, id.name="LinsearWrite")
kRp.rdb.chk.nWS <- rk.XML.cbox(label="Wiener Sachtextformeln (nWS 1-4)", value="nWS", chk=TRUE, id.name="nWS")
kRp.rdb.chk.Coleman <- rk.XML.cbox(label="Coleman (C 1-4)", value="Coleman", chk=TRUE, id.name="Coleman")
kRp.rdb.chk.ELF <- rk.XML.cbox(label="Easy Listening Formula", value="ELF", chk=TRUE, id.name="ELF")
kRp.rdb.chk.TRI <- rk.XML.cbox(label="Kuntzsch's Text-Redundanz-Index", value="TRI", chk=TRUE, id.name="TRI")

kRp.rdb.frm.needSylls <- rk.XML.frame(
	rk.XML.text("Selecting one of these indices will automatically activate syllable count."),
	rk.XML.row(
		rk.XML.col(
			kRp.rdb.chk.Flesch,
			kRp.rdb.chk.FleschPSK,
			kRp.rdb.chk.FleschKincaid,
			kRp.rdb.chk.FarrJenkinsPaterson,
			kRp.rdb.chk.FarrJenkinsPatersonPSK,
			kRp.rdb.chk.FOG,
			kRp.rdb.chk.FOGPSK,
			kRp.rdb.chk.FOGNRI,
			kRp.rdb.chk.SMOG,
			kRp.rdb.chk.Qu
		),
		rk.XML.col(
			kRp.rdb.chk.WheelerSmith,
			kRp.rdb.chk.WheelerSmithDe,
			kRp.rdb.chk.FORCAST,
			kRp.rdb.chk.Strain,
			kRp.rdb.chk.LinsearWrite,
			kRp.rdb.chk.nWS,
			kRp.rdb.chk.Coleman,
			kRp.rdb.chk.ELF,
			kRp.rdb.chk.TRI,
			rk.XML.stretch()
		)
	),
	label="Formulae that need syllable count",
	id.name="frameReadabilityNeedSylls"
)

kRp.rdb.chk.DaleChall <- rk.XML.cbox(label="Dale-Chall (1995)", value="Dale.Chall", chk=TRUE, id.name="DaleChall")
kRp.rdb.chk.DaleChallPSK <- rk.XML.cbox(label="Dale-Chall (Powers-Sumner-Kearl)", value="Dale.Chall.PSK", chk=TRUE, id.name="DaleChallPSK")
kRp.rdb.chk.DaleChallOld <- rk.XML.cbox(label="Dale-Chall (1948)", value="Dale.Chall.old", chk=TRUE, id.name="DaleChallOld")
kRp.rdb.chk.Bormuth <- rk.XML.cbox(label="Bormuth Mean Cloze + Grade", value="Bormuth", chk=TRUE, id.name="Bormuth")
kRp.rdb.chk.Spache <- rk.XML.cbox(label="Spache", value="Spache", chk=TRUE, id.name="Spache")
kRp.rdb.chk.SpacheOld <- rk.XML.cbox(label="Spache (old)", value="Spache.old", chk=TRUE, id.name="SpacheOld")
kRp.rdb.chk.DRP <- rk.XML.cbox(label="Degrees of Reading Power", value="DRP", chk=TRUE, id.name="DRP")
kRp.rdb.brw.lDaleChall <- rk.XML.browser(label="Long Dale-Chall word list:", filter="*.txt", required=FALSE, id.name="readbWLldc")
kRp.rdb.brw.sDaleChall <- rk.XML.browser(label="Short Dale-Chall word list:", filter="*.txt", required=FALSE, id.name="readbWLsdc")

kRp.rdb.frm.NeedWL <- rk.XML.frame(
	rk.XML.text("If you select one of these indices you will also need to provide word lists as indicated below."),
	rk.XML.row(
		rk.XML.col(
			kRp.rdb.chk.DaleChall,
			kRp.rdb.chk.DaleChallPSK,
			kRp.rdb.chk.DaleChallOld,
			kRp.rdb.chk.Bormuth
		),
		rk.XML.col(
			kRp.rdb.chk.Spache,
			kRp.rdb.chk.SpacheOld,
			kRp.rdb.chk.DRP,
			rk.XML.stretch()
		)
	),
	rk.XML.row(
		rk.XML.col(
			kRp.rdb.brw.lDaleChall,
			kRp.rdb.brw.sDaleChall
		),
		id.name="rowWLfile"
	),
	id.name="frameReadabilityNeedWL",
	label="Formulae that need word lists"
)

kRp.rdb.frm.show <- rk.XML.frame(
	kRp.rdb.chk.show <- rk.XML.cbox(label="List results in output (slow for long texts!)", value="readability", id.name="showReadb")
)

kRp.rdb.saveobj <- rk.XML.saveobj(label="Keep results", initial="readability.obj", chk=TRUE, id.name="saveReadb")

kRp.tab.rdb <- list(
	rk.XML.row(
		rk.XML.col(kRp.hyph.vars),
		rk.XML.col(
 			kRp.hyph.data,
			rk.XML.stretch(),
	kRp.rdb.frm.rdb,
	kRp.rdb.frm.needSylls,
	kRp.rdb.frm.NeedWL,
	kRp.rdb.frm.show,
	kRp.rdb.saveobj
	))
)

kRp.dialog.rdb <- rk.XML.dialog(kRp.tab.rdb, label="Readability")

# 		<connect client="frameReadabilityIndices.enabled" governor="chkReadability.state" />
# 		<connect client="frameReadabilityNeedSylls.enabled" governor="chkReadability.state" />
# 		<connect client="frameReadabilityNeedWL.enabled" governor="chkReadability.state" />
# 		<connect client="saveReadb.enabled" governor="chkReadability.state" />
# 
# 		<convert id="logicHyphInvert" mode="equals" sources="Flesch.state;FleschKincaid.state;FarrJenkinsPaterson.state;FOG.state;SMOG.state;WheelerSmith.state;FORCAST.state;Strain.state;LinsearWrite.state;nWS.state;Coleman.state;ELF.state;Amdahl.state" standard="" />
# 		<connect client="rowChkHyph.enabled" governor="logicHyphInvert" />
# 
# 		<convert id="logicNeedsHyphenation" mode="or"
# 			sources="Flesch.state;FleschKincaid.state;FarrJenkinsPaterson.state;FOG.state;SMOG.state;WheelerSmith.state;FORCAST.state;Strain.state;LinsearWrite.state;nWS.state;Coleman.state;ELF.state;Amdahl.state" />
# 		<connect client="chkCustomHyph.state" governor="logicNeedsHyphenation" />
# 
# 		<convert id="logicNeedsLongDCWL" mode="or" sources="DaleChall.state;Bormuth.state;DRP.state" />
# 		<convert id="logicNeedsShortDCWL" mode="or" sources="Spache.state" />
# 		<connect client="readbWLldc.enabled" governor="logicNeedsLongDCWL"/>
# 		<connect client="readbWLldc.required" governor="logicNeedsLongDCWL"/>
# 		<connect client="readbWLsdc.enabled" governor="logicNeedsShortDCWL"/>
# 		<connect client="readbWLsdc.required" governor="logicNeedsShortDCWL"/>


kRp.rdb.js.calc <- rk.paste.JS(
	kRp.rdb.array <- rk.JS.array("index", variables=list(
		kRp.rdb.chk.LIX,
		kRp.rdb.chk.RIX,
		kRp.rdb.chk.ARI,
		kRp.rdb.chk.ARINRI,
		kRp.rdb.chk.ColemanLiau,
		kRp.rdb.chk.DickesSteiwer,
		kRp.rdb.chk.Fucks,
		kRp.rdb.chk.DanielsonBrian,
		kRp.rdb.chk.Flesch,
		kRp.rdb.chk.FleschPSK,
		kRp.rdb.chk.FleschKincaid,
		kRp.rdb.chk.FarrJenkinsPaterson,
		kRp.rdb.chk.FarrJenkinsPatersonPSK,
		kRp.rdb.chk.FOG,
		kRp.rdb.chk.FOGPSK,
		kRp.rdb.chk.FOGNRI,
		kRp.rdb.chk.SMOG,
		kRp.rdb.chk.Qu,
		kRp.rdb.chk.WheelerSmith,
		kRp.rdb.chk.WheelerSmithDe,
		kRp.rdb.chk.FORCAST,
		kRp.rdb.chk.Strain,
		kRp.rdb.chk.LinsearWrite,
		kRp.rdb.chk.nWS,
		kRp.rdb.chk.Coleman,
		kRp.rdb.chk.ELF,
		kRp.rdb.chk.TRI,
		kRp.rdb.chk.DaleChall,
		kRp.rdb.chk.DaleChallPSK,
		kRp.rdb.chk.DaleChallOld,
		kRp.rdb.chk.Bormuth,
		kRp.rdb.chk.Spache,
		kRp.rdb.chk.SpacheOld,
		kRp.rdb.chk.DRP
	), quote=TRUE),
	echo("readability.obj <- readability(", kRp.hyph.data, kRp.rdb.array, ", quiet=TRUE)\n")
)

kRp.rdb.component <- rk.plugin.component("Readability",
	xml=list(
# 		logic=pd.lgc.sect,
		dialog=kRp.dialog.rdb),
 	js=list(
 		calculate=kRp.rdb.js.calc#,
# 		printout=pd.js.print
	),
	guess.getter=guess.getter,
	hierarchy=menu.hierarchy,
	create=c("xml", "js"))


#############
## if you run the following function call, files will be written to output.dir!
#############
# this is where it get's serious, that is, here all of the above is put together into one plugin

rk.kRp.dir <<- rk.plugin.skeleton(
	about.info,
	path=output.dir,
	guess.getter=guess.getter,
	xml=list(
		logic=kRp.POS.lgc.sect,
		dialog=kRp.dialog.POS),
	js=list(
		require="koRpus",
		calculate=kRp.POS.js.calc#,
#		printout=js.print,
#		load.silencer=var.chk.suppress
	),
	pluginmap=list(name="Tokenizing & POS tagging", hierarchy=menu.hierarchy),
	components=list(
		kRp.hyph.component,
		kRp.rdb.component),
	dependencies=dependencies.info,
	create=c("pmap", "xml", "js"),
	overwrite=overwrite,
	tests=FALSE,
#	edit=TRUE,
	load=TRUE,
	hints=FALSE)#,
#	show=TRUE)

})
