% Generated by roxygen2 (4.0.1): do not edit by hand
\docType{methods}
\name{kobeProb}
\alias{kobeProb}
\title{kobeProb}
\usage{
kobeProb(x, y, prob = c(0.5, 0.75, 0.95), n = 21, h = c(bandwidth.nrd(x),
  bandwidth.nrd(y)), lims = NULL, na.rm = FALSE)
}
\arguments{
\item{x}{a vector}

\item{y}{a vector}

\item{prob}{probability levels}

\item{n}{number of points at which to evaluate the density grid}

\item{h}{bandwidth of 2D kernel smoother (previous default value was c(1,1), which worked
poorly with some plots with very small scales; if not specified, defaults to values in kde2d)}

\item{lims}{limits, specified as (x.lower,x.upper,y.lower,y.upper) (passed to kde2d)}

\item{na.rm}{logical; if true, any NA and NaN's are removed from x before calculations}
}
\value{
a \code{data.frame} with three variables
\code{x, y} coordinates of the grid points, vectors of length n.
\code{level} contours corresponding to \code{prob}
}
\description{
Calculates the probability of an obervations occurring in a 2D cell using HPDregionplot
Given a sample calculates the  bivariate region of highest marginal posterior density
for two variables, using kde2d from MASS to calculate a bivariate density.
}
\examples{
\dontrun{
   y=rnorm(20)
   x  =rnorm(20)
   kobeProb(x,y)}
}

