% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocessingFunctions.R
\name{suggest_threshold}
\alias{suggest_threshold}
\title{Data-driven identification of threshold parameters for adaptive veloctity-based saccade detection.}
\usage{
suggest_threshold(
  gaze,
  velocity.filter.ms = 10,
  one_degree = 40,
  ycol = "y.raw",
  xcol = "x.raw",
  peak.threshold.start = 130,
  onset.threshold.sd = 3,
  min.period.ms = 40,
  margin.ms = 3
)
}
\arguments{
\item{gaze}{Data frame with gaze data before saccade and fixation data identification. The data frame must include the variable timestamp with
timing in milliseconds and columns for x and y coordinates specified by the columns 'xcol' and 'ycol' respectively.}

\item{velocity.filter.ms}{If velocity.filter.ms is not NA, the velocity vector is smoothed using a moving median filter corresponding to this value in ms
before the propose threshold is identified. Default: 10.}

\item{one_degree}{one degree of the visual field in the unit of the x and y coordinates in the data. Typically pixels or degrees.}

\item{ycol}{column in the gaze data frame where y coordinates are found. Default: y.raw}

\item{xcol}{column in the gaze data frame where x coordinates are found. Default: x.raw}

\item{peak.threshold.start}{initial peak threshold value in degrees of the visual field. Default: 200}

\item{onset.threshold.sd}{sd of sample-by-sample velocities used to select the proposed velocity threshold (proposed.velocity.threshold)}

\item{min.period.ms}{Update the peak velocity thresholds iteratively based on data within consecuitive runs of samples below the previous thresholds. Should be approximately
minimum fixation duration.}

\item{margin.ms}{A margin around min.period.ms. This reduces the risk that samples included in the threshold estimation belong o a saccade}
}
\value{
list including separate data frames for proposed saccade onset threshold, peak threshold, and sample-to-sample velocity
}
\description{
The function is based on a procedure suggested by Nyström and Holmqvist 2010. Behavior Research Methods, 42, 188-204. The function can be used to identify
specific thresholds for saccade onset for individuals and/or segments of the data, as an alternative to using the same thresholds for each participants. It is
used in kollaR by the function 'algorithm_adaptive'

Peak velocity and saccade amplitude are typically highly postively correlated. It is therefore important to consider that differences in gaze behavior
between individuals and/or data segment may lead to differences in proposed saccade onset velocity threshold.
#'
The input data should be pre-processed (e.g., noise removal and interpolation over gaps)
The output is a list with three cells: "peak.threshold" and "onset.threshold" are parameters used by the
function algorithm_adaptive (see Nyström and Holmqvist 2010 for details). "velocity" is a data frame with sample-to-sample velocity in the unit specified by the
parameter one_degree
}
