% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mscale.R
\name{normal_consistency_constants}
\alias{normal_consistency_constants}
\title{normal_consistency_constants}
\usage{
normal_consistency_constants(p)
}
\arguments{
\item{p}{dimension where observation lives}
}
\value{
cvalue
}
\description{
constants previously computed in order the M scale value is consistent
with the standard normal distribution for the optimal rho function considered in \code{\link{rhoOpt}}.
(Constant were computed from p=1 till p =400)
}
\examples{
p=5;
n=1000
X=matrix(rnorm(n*p), ncol=p)
dist=apply(X,1,function(t){sqrt(sum(t^2))})
s= Mscale(dist,b=0.5, c=normal_consistency_constants(p))

### variable s should be near from one for all p values between 1 and 400.

}
\references{
[1] Maronna, R. A., Martin, R. D., Yohai, V. J., & Salibián-Barrera, M. (2018).
Robust statistics: theory and methods (with R). Wiley.
[2] Salibian-Barrera, M., Willems, G., & Zamar, R. (2008).
The fast-tau estimator for regression.
Journal of Computational and Graphical Statistics, 17(3), 659-682.
}
