% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textUtils.R
\name{alphaOnly}
\alias{alphaOnly}
\title{Keep only alpha-numeric symbols}
\usage{
alphaOnly(x, also)
}
\arguments{
\item{x}{text string, or vector of strings (each of which is
processed separately)}

\item{also}{A named vector of other symbols that the user wants to
remove, along with replacements. For example, c(" " = "_",
"-" = "", "+" = "") to replace space with underscore and minus
and plus signs with nothing.}
}
\value{
cleaned text string
}
\description{
From a text string, keep ASCII letters, numbers, as well as "'",
" ", "_" "(", ")", "-", and "+". For maximum compatability with
the cross-platform file-naming standard. Obliterates all
characters that migth be mistaken for shell symbols, like "\^",
"\$", "\@" and so forth.
}
\details{
Removes trailing spaces.

This version allows internal spaces in the string, by default. The
also argument can be used to eliminate spaces or other hated symbols.
}
\examples{
x <- c("[]kansas(city) Missouri", "percent\%slash/",
       "\\back{squiggle}_under(paren)", "*star-minus+plus")
alphaOnly(x)
alphaOnly(x, also = c(" " = "_", "+" = "_"))
alphaOnly(x, also = c("(" = "[", ")" = "]"))
}
\author{
Paul Johnson
}

