% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{wide2long}
\alias{wide2long}
\title{Convert a key object from wide to long format}
\usage{
wide2long(key, sep = c(character = "\\\\|", logical = "\\\\|", integer =
  "\\\\|", factor = "[\\\\|<]", ordered = "[\\\\|<]", numeric = "\\\\|"))
}
\arguments{
\item{key}{A variable key in the wide format}

\item{sep}{Default separator is the pipe, "\\|" for most
variables, while ordered accepts pipe or less than, "\\|<". If
the key did not follow those customs, other sep values may be
specified for each variable class.}
}
\value{
A long format variable key
}
\description{
This is not flexible, assumes columns are named in our canonical
style, which means the columns are named c("name_old", "name_new",
"class_old", "class_new", "value_old", "value_new").
}
\examples{
mydf.path <- system.file("extdata", "mydf.csv", package = "kutils")
mydf <- read.csv(mydf.path, stringsAsFactors=FALSE)
## Target we are trying to match:
mydf.keylong <- keyTemplate(mydf, long = TRUE, sort = FALSE)
## View(mydf.keylong)

mydf.key <- keyTemplate(mydf)
mydf.keywide2long <- wide2long(mydf.key)

## rownames not meaningful in long key, so remove in both versions
row.names(mydf.keywide2long) <- NULL
row.names(mydf.keylong) <- NULL
all.equal(mydf.keylong, mydf.keywide2long)
}
\author{
Paul Johnson
}

