% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{starsig}
\alias{starsig}
\title{How many stars would we need for this p value?}
\usage{
starsig(pval, alpha = c(0.05, 0.01, 0.001), symbols = c("*", "**", "***"))
}
\arguments{
\item{pval}{P value}

\item{alpha}{alpha vector, defaults as c(0.05, 0.01, 0.001).}

\item{symbols}{The default is c("*", "**", "***"), corresponding
to mean that p values smaller than 0.05 receive one star,
values smaller than 0.01 get two stars, and so forth.  Must be
same number of elements as alpha. These need not be asterixes,
could be any character strings that users desire. See example.}
}
\value{
a character vector of asterixes, same length as pval
}
\description{
Regression table makers need to know how many stars
to attach to parameter estimates. This takes
p values and a vector which indicates how many stars
are deserved.  It returns a required number of asterixes.
Was named "stars" in previous version, but renamed due to
conflict with R base function \code{stars}
}
\details{
Recently, we have requests for different symbols. Some people want
a "+" symbol if the p value is smaller than 0.10 but greater than
0.05, while some want tiny smiley faces if p is smaller than
0.001. We accomodate that by allowing a user specified vector of
symbols, which defaults to c("*", "**", "***")
}
\examples{
starsig(0.06)
starsig(0.021)
starsig(0.001)
alpha.ex <- c(0.10, 0.05, 0.01, 0.001)
symb.ex <- c("+", "*", "**", ":)!")
starsig(0.07, alpha = alpha.ex, symbols = symb.ex)
starsig(0.04, alpha = alpha.ex, symbols = symb.ex)
starsig(0.009, alpha = alpha.ex, symbols = symb.ex)
starsig(0.0009, alpha = alpha.ex, symbols = symb.ex)

}
\author{
Paul Johnson <pauljohn@ku.edu>
}
