% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verification.R
\name{example1}
\alias{example1}
\title{USGS verification example: model parameterisation (multiple distances)}
\usage{
example1(x = c(0, 0.3, 3.3, 6.6, 10, 20, 25, 30, 40, 50, 75, 100, 150,
  200), baseProps = baseProps_ex1(), dbg = FALSE)
}
\arguments{
\item{x}{distance from the center of the recharge basin in the x direction (L)}

\item{baseProps}{basic model properties as retrieved by baseProps_ex1()}

\item{dbg}{If True additional messages on debug messages}
}
\description{
USGS verification example: model parameterisation (multiple distances)
}
\examples{
res <- example1()
if (FALSE) {
  #### Head for each time step (defined with parameter "numberTimeSteps)
  xyplot(head ~ x | as.factor(sprintf("\%f days", timeSteps)),
    data = res$timeSteps,
    type = "b",
    las = 1,
    as.table = TRUE
  )
  #### Head at end of simulation
  plot(head ~ x,
    data = res$simTime,
    type = "b",
    las = 1
  )
}
#### Water level increase at end of simulation & compare to alternative models
modelComparison <- compareModelResults(conf = res)
plotModelComparison(modelComparison = modelComparison)
}
\references{
p.23, \url{https://pubs.usgs.gov/sir/2010/5102/support/sir2010-5102.pdf}
}
