% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add1m1.R
\name{add1m1}
\alias{add1m1}
\title{Apply One Label to Multiple Values for a Single Variable}
\usage{
add1m1(data, var, vals, lab, max.unique.vals = 10, init = FALSE)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{a character vector that corresponds to the name(s) of one or more
variables to which value labels will be added.}

\item{vals}{a vector of distinct values of the actual variable, each of which
is to be associated with the label supplied to the lab argument. Note: NA and
other "irregular" (e.g., NaN, Inf) values all are automatically assigned the
label "NA", and this cannot be overridden. Note that you do not need to
specify all unique vals of var, and you can supply value labels
incrementally, one (or a few, or all) unique vals of var at a time. However,
if you do this, do not re-use a value label or repeat a value-label
assignment you have already made: Once you've added the value label, it is
bound to those values until you drop the label (see \code{drop_val_labs}) or some
other action (intentional or otherwise) strips the value label attributes
from your data.frame (see, e.g. \code{strip_labs}).}

\item{lab}{a single distinct label that will be associated with all values
specified in your vals argument. Note: NA and other "irregular" (e.g.,
NaN, Inf) values are automatically assigned the label "NA" and may not be
assigned another label.}

\item{max.unique.vals}{\code{add1m1}() will not assign value labels to non-
integer (i.e., decimal-having) numeric variables. The max.unique.vals
argument further constrains the variables that may receive value labels to
those whose total unique values do not exceed the integer value supplied to
this argument.}

\item{init}{assign placeholder labels for variables that lack decimals
and meet the max.unique.vals threshold.}
}
\value{
A data.frame, with new variable value labels added (call
\code{get_val_labs} to see them), other provisional/default labelr label
information added, and previous user-added labelr label information
preserved.
}
\description{
Apply a single variable value label to multiple values of a variable
("m1" is shorthand for "many values get one label").
}
\details{
Note 1: \code{add1m1} is a variant of \code{add_m1_lab} that allows you to specify
only one var to label but allows you to pass its name without quoting it
(compare \code{add1m1}(mtcars, am, ...) to \code{add_m1_lab}(mtcars, "carb", ...).

Note 2: \code{add1m1} (and \code{add_m1_lab}) allows the user to assign the same value
label to multiple distinct values of a variable ("m1" is short for
"many-to-one"). This is in contrast to \code{add_val1} (and \code{add_val_labs}), which
requires a strict one-to-one mapping of distinct variable values and distinct
value labels.
}
\examples{
df <- mtcars

df <- add1m1(df,
  var = carb,
  vals = 1:3,
  lab = "<=3",
  max.unique.vals = 10
)

df <- add1m1(df,
  var = carb,
  vals = c(4, 6, 8),
  lab = ">=4",
  max.unique.vals = 10
)

head(use_val_labs(df), 8) # they're there
}
