% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lab_cols.R
\name{add_lab_cols}
\alias{add_lab_cols}
\alias{alc}
\title{Add Variable Value Label Columns to a Data Frame}
\usage{
add_lab_cols(data, vars = NULL, suffix = "_lab")

alc(data, vars = NULL, suffix = "_lab")
}
\arguments{
\item{data}{a data.frame.}

\item{vars}{the names of the columns (variables) for which "labels-on"
(values replaced with value labels) versions of the variable will be added to
the returned data.frame.}

\item{suffix}{a suffix that will be added to the names of all labels-on
variables added to the data.frame (the non-suffix portion of the variable
name will be identical to the original variable, e.g., the labels-on version
of "x1" will be "x1_lab" (or whatever alternative suffix you supply)).}
}
\value{
A data.frame consisting of the originally supplied data.frame, along
with (all or the select) labels-on variable versions added to it.
}
\description{
Add copies of value-labeled columns to a data.frame, where the new columns'
values are replaced with the corresponding value labels.
}
\details{
Note: \code{alc} is a compact alias for \code{add_lab_cols}: they do the same thing,
and the former is easier to type.

\code{add_lab_cols} adds one or more "labels-on" columns to a data.frame, where
"labels-on" means that the column's original values are replaced with the
corresponding value labels. Note that these columns do not replace but are
added to their parent/source columns in the returned data.frame. The
resulting "labels-on" columns are simple, self-contained character columns
that cannot themselves be converted or reverted to the original
("labels-off") values of their parent/source columns.

For other ways of accessing or leveraging value labels, see, e.g.,
\code{use_val_labs}, \code{val_labs_vec}, \code{add_lab_dummies}, \code{lab_int_to_factor},
\code{flab}, \code{slab}, \code{get_val_labs}, \code{with_val_labs}, \code{headl}, \code{taill}, \code{somel},
and \code{tabl}. In particular, see \code{use_val_labs} if, rather than adding a
"labels-on" column to a data.frame, you wish to replace a column's values
with the corresponding value labels. See \code{val_labs_vec} if you wish to
convert a single, value-labeled column's values to labels and return the
result as a stand-alone vector, see \code{val_labs_vec}.
}
\examples{
# one variable at a time, mtcars
df <- mtcars
# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

# var arg can be unquoted if using add_val1()
# note that this is not add_val_labs(); add_val1() has "var" (not "vars) arg
df <- add_val1(
  data = df,
  var = cyl, # note, "var," not "vars" arg
  vals = c(4, 6, 8),
  labs = c(
    "four-cyl",
    "six-cyl",
    "eight-cyl"
  )
)

df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = c(3, 4),
  labs = c(
    "3-speed",
    "4-speed"
  )
)

# Oops, we forgot 5-speeds; let's finish the job.
df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = 5,
  labs = "5-speed"
)

# add value labels-on versions of the foregoing to df and return as "df_plus"
df_plus <- add_lab_cols(df)
head(df_plus)
head(df_plus[c("am", "am_lab")])
}
