% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_val1.R
\name{drop_val1}
\alias{drop_val1}
\alias{dvl1}
\title{Drop a Single Variable's Value Labels}
\usage{
drop_val1(data, var)

dvl1(data, var)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable whose value labels will be
dropped.}
}
\value{
A data.frame, with all value labels dropped from specified variable.
}
\description{
Drop all value labels previously applied to one or more variables using
\code{add_val_labs}, \code{add_quant_labs},\code{add_m1_lab}, and related functions (e.g.,
\code{add_val1}) or aliases (e.g., \code{avl}).

Note: \code{dvl1} is a compact alias for \code{drop_val1}: they do the same thing,
and the former is easier to type
}
\details{
Note: \code{drop_val1} is the \code{drop_val_labs} analogue to \code{add_val1}: just as
\code{add_val1} is a variant of \code{add_val_labs} that allows you to specify only one
variable at a time unquoted for value labeling, \code{drop_val1} allows you to
pass one unquoted variable name at a time for value dropping. See those
functions for further details regarding the conventions.
}
\examples{
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val1(
  data = dflik, var = x3,
  vals = vals2label,
  labs = labs2use
)

# see what this did
get_val_labs(dflik, "x3")

dfdrop <- drop_val1(dflik,
  var = x3
) # odd choice, but ok

# var x3's value labels are gone, like we asked for
get_val_labs(dfdrop, "x3")
}
