% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_numable.R
\name{is_numable}
\alias{is_numable}
\title{Test Whether Character Vector Is "Suitable" for Numeric Conversion}
\usage{
is_numable(x, nan2na = TRUE, inf2na = TRUE)
}
\arguments{
\item{x}{a character vector.}

\item{nan2na}{treat NaN (including, e.g., "nan") values as NA values.}

\item{inf2na}{treat Inf, -Inf values (including, e.g., "inf") as NA values.
treated as equivalent to NA values.}
}
\value{
a 1L (scalar) logical vector.
}
\description{
\code{is_numable} determines whether a character vector can be coerced to numeric
without generating new NA values.
}
\details{
Core labelr functions coerce integers to characters and back, which
\code{is_numable} facilitates.
}
\examples{
set.seed(123)
x1 <- runif(10)
x2 <- as.character(sample(c(1:20), 10, replace = TRUE))
x2_num_test <- is_numable(x2)
x2_num_test
x3 <- sample(LETTERS, 10, replace = TRUE)
x3_num_test <- is_numable(x3)
x3_num_test
}
