% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_factor_info.R
\name{get_factor_info}
\alias{get_factor_info}
\title{Return Factor Attributes as a Data Frame}
\usage{
get_factor_info(data, var = NULL)
}
\arguments{
\item{data}{the labelr labeled data.frame you are checking for factor
variables.}

\item{var}{a 1L character vector with the name of a specific variable (column)
of data, if you wish to restrict query to a single variable (else, keep NULL
and will get info for any relevant variables).}
}
\value{
A data.frame with three columns: "factor.var" (the name of the factor
variable in question), "levels" (the given level of that factor, expressed as
a character), and "ordered" (TRUE if so, FALSE if not). If no factors are
present in the supplied data.frame, a one-row data.frame of same structure
with all three cells set to NA.
}
\description{
\code{get_factor_info} searches a labelr labeled data.frame for factors. If any
are found, a data.frame is returned with the name and unique factor levels of
each, along with a logical indicator of whether the factor is ordered, with
one row per level per factor. If none are found, a one-row data.frame of NA
values is returned.
}
\examples{
ir2 <- iris
unique(ir2$Species)

ir2 <- add_val_labs(ir2,
  vars = "Species", vals = c(
    "setosa",
    "versicolor",
    "virginica"
  ),
  labs = c("se", "ve", "vi")
)
get_val_labs(ir2)
head(use_val_labs(ir2))
get_factor_info(iris) # no such info: iris is not labelr labeled
get_factor_info(ir2) # this one has info: it's labelr labeled
}
