% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_labs.R
\name{strip_labs}
\alias{strip_labs}
\title{Strip All labelr Meta-data from a Data Frame}
\usage{
strip_labs(data)
}
\arguments{
\item{data}{a data.frame object.}
}
\value{
a data.frame object with label attribute meta-data stripped from it.
}
\description{
\code{strip_labs} removes all labelr meta-data attributes ("name.labs", "val.labs",
"frame.lab", and "factor.") from a data.frame, because you no longer want/need
it for some reason or another.
}
\details{
Some labelr functions automatically use \code{strip_labs}, but you should only
use it if you no longer want or need a given data.frame's labelr meta-data
(i.e., labels). If you have saved your labelr attributes (using
\code{get_all_lab_atts}), you can restore them to the data.frame using
\code{add_lab_atts}).
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

get_val_labs(df, "raceth") # it's here
df <- strip_labs(df) # this removes labs from df
get_val_labs(df, "raceth") # it's gone
check_any_lab_atts(df) # FALSE (means "no labs here")
}
