% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Field.R
\name{Field}
\alias{Field}
\title{Field}
\description{
A field in a registry.
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{type}}{(\code{character(1)})\cr
The type of the field.}

\item{\code{through}}{(\code{list()} or \code{NULL})\cr
The through value of the field.}

\item{\code{field_name}}{(\code{character(1)})\cr
The field name.}

\item{\code{registry_name}}{(\code{character(1)})\cr
The registry name.}

\item{\code{column_name}}{(\code{character(1)})\cr
The column name.}

\item{\code{module_name}}{(\code{character(1)})\cr
The module name.}

\item{\code{is_link_table}}{(\code{logical(1)})\cr
Whether the field is a link table.}

\item{\code{relation_type}}{(\code{character(1)} or \code{NULL})\cr
The relation type. Can be one of: "one-to-many", "many-to-one", "many-to-many".}

\item{\code{related_field_name}}{(\code{character(1)} or \code{NULL})\cr
The related field name.}

\item{\code{related_registry_name}}{(\code{character(1)} or \code{NULL})\cr
The related registry name.}

\item{\code{related_module_name}}{(\code{character(1)} or \code{NULL})\cr
The related module name.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Field-new}{\code{Field$new()}}
\item \href{#method-Field-print}{\code{Field$print()}}
\item \href{#method-Field-to_string}{\code{Field$to_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Field-new"></a>}}
\if{latex}{\out{\hypertarget{method-Field-new}{}}}
\subsection{Method \code{new()}}{
Creates an instance of this R6 class. This class should not be instantiated directly,
but rather by connecting to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Field$new(
  type,
  through,
  field_name,
  registry_name,
  column_name,
  module_name,
  is_link_table,
  relation_type,
  related_field_name,
  related_registry_name,
  related_module_name
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{The type of the field. Can be one of:
"IntegerField", "JSONField", "OneToOneField", "SmallIntegerField",
"BigIntegerField", "AutoField", "BigAutoField", "BooleanField", "TextField",
"DateTimeField", "ManyToManyField", "CharField", "ForeignKey"}

\item{\code{through}}{If the relation type is one-to-many, many-to-one, or many-to-many,
This value will be a named list with keys 'left_key', 'right_key', 'link_table_name'.}

\item{\code{field_name}}{The name of the field in the registry. Example: \code{"name"}.}

\item{\code{registry_name}}{The name of the registry. Example: \code{"user"}.}

\item{\code{column_name}}{The name of the column in the database. Example: \code{"name"}.}

\item{\code{module_name}}{The name of the module. Example: \code{"core"}.}

\item{\code{is_link_table}}{Whether the field is a link table.}

\item{\code{relation_type}}{The type of relation. Can be NULL or one of: "one-to-one", "many-to-one", "many-to-many".}

\item{\code{related_field_name}}{The name of the related field in the related registry. Example: \code{"name"}.}

\item{\code{related_registry_name}}{The name of the related registry. Example: \code{"user"}.}

\item{\code{related_module_name}}{The name of the related module. Example: \code{"core"}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Field-print"></a>}}
\if{latex}{\out{\hypertarget{method-Field-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{Field}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Field$print(style = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Field-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-Field-to_string}{}}}
\subsection{Method \code{to_string()}}{
Create a string representation of a \code{Field}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Field$to_string(style = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cli::cli_ansi_string} if \code{style = TRUE} or a character vector
}
}
}
