% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Record.R
\name{Record}
\alias{Record}
\title{Record}
\description{
A record from a registry.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Record-new}{\code{Record$new()}}
\item \href{#method-Record-delete}{\code{Record$delete()}}
\item \href{#method-Record-print}{\code{Record$print()}}
\item \href{#method-Record-to_string}{\code{Record$to_string()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Record-new"></a>}}
\if{latex}{\out{\hypertarget{method-Record-new}{}}}
\subsection{Method \code{new()}}{
Creates an instance of this R6 class. This class should not be instantiated directly,
but rather by connecting to a LaminDB instance using the \code{\link[=connect]{connect()}} function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Record$new(instance, registry, api, data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{The instance the record belongs to.}

\item{\code{registry}}{The registry the record belongs to.}

\item{\code{api}}{The API for the instance.}

\item{\code{data}}{The data for the record.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Record-delete"></a>}}
\if{latex}{\out{\hypertarget{method-Record-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a \code{Record}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Record$delete(verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{Whether to print details of the API call}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} invisibly if the deletion is successful
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Record-print"></a>}}
\if{latex}{\out{\hypertarget{method-Record-print}{}}}
\subsection{Method \code{print()}}{
Print a \code{Record}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Record$print(style = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Record-to_string"></a>}}
\if{latex}{\out{\hypertarget{method-Record-to_string}{}}}
\subsection{Method \code{to_string()}}{
Create a string representation of a \code{Record}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Record$to_string(style = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{Logical, whether the output is styled using ANSI codes}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{cli::cli_ansi_string} if \code{style = TRUE} or a character vector
}
}
}
