% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_lsm.R
\name{sample_lsm}
\alias{sample_lsm}
\alias{sample_lsm.RasterLayer}
\alias{sample_lsm.RasterStack}
\alias{sample_lsm.RasterBrick}
\alias{sample_lsm.list}
\title{sample_lsm}
\usage{
sample_lsm(landscape, what, shape, points, size, return_plots, ...)

\method{sample_lsm}{RasterLayer}(landscape, what = "all",
  shape = "square", points, size, return_plots = FALSE, ...)

\method{sample_lsm}{RasterStack}(landscape, what = "all",
  shape = "square", points, size, return_plots = FALSE, ...)

\method{sample_lsm}{RasterBrick}(landscape, what = "all",
  shape = "square", points, size, return_plots = FALSE, ...)

\method{sample_lsm}{list}(landscape, what = "all", shape = "square",
  points, size, return_plots = FALSE, ...)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{what}{Selected level of metrics: either "all", "patch", "class", "landscape".
The default is "all". It is also possible to specify functions as a vector of strings,
e.g. what = c("lsm_c_ca", "lsm_l_ta").}

\item{shape}{String specifying plot shape. Either "circle" or "square"}

\item{points}{SpatialPoints, sf or 2-column matrix with coordinates of sample points}

\item{size}{Approximated size of sample plot. Equals the radius for circles or the
side-length for squares in mapunits}

\item{return_plots}{Logical if the clipped raster of the sample plot should
be returned}

\item{...}{Options for calculate_lsm()}
}
\value{
tibble
}
\description{
Sample metrics
}
\details{
This function samples the selected metrics in a buffer area (sample plot)
around sample points. The size of the actual sampled landscape can be different
to the provided size due to two reasons. Firstly, because clipping raster
cells using a circle or a sample plot not directly at a cell center lead
to inaccuracies. Secondly, sample plots can exceed the landscape boundary.
Therefore, we report the actual clipped sample plot area relative in relation
to the theoretical, maximum sample plot area e.g. a sample plot only half within
the landscape will have a \code{percentage_inside = 50}. Please be aware that the
output is sligthly different to all other \code{lsm}-function of \code{landscapemetrics}.
}
\examples{
points <- matrix(c(10, 5, 25, 15, 5, 25), ncol = 2, byrow = TRUE)
sample_lsm(landscape, points = points, size = 15, what = "lsm_l_np")

points_sp <- sp::SpatialPoints(points)
sample_lsm(landscape, points = points_sp, size = 15, what = "lsm_l_np", return_plots = TRUE)

}
