% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_pland.R
\name{lsm_c_pland}
\alias{lsm_c_pland}
\title{PLAND (class level)}
\usage{
lsm_c_pland(landscape, directions = 8)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Percentage of landscape of class (Area and Edge metric)
}
\details{
\deqn{PLAND = \frac{\sum \limits_{j = 1}^{n} a_{ij}} {A} * 100}
where \eqn{a_{ij}} is the area of each patch and \eqn{A} is the total
landscape area.

PLAND is an 'Area and edge metric'. It is the percentage of the landscape
belonging to class i. It is a measure of composition and because of the relative
character directly comparable among landscapes with different total areas.

\subsection{Units}{Percentage}
\subsection{Range}{0 < PLAND <= 100}
\subsection{Behaviour}{Approaches PLAND = 0 when the proportional class area is decreasing.
Equals PLAND = 100 when only one patch is present.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_c_pland(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org
}
\seealso{
\code{\link{lsm_c_ca}},
\code{\link{lsm_l_ta}}
}
